package j3d.examples;

import com.sun.j3d.utils.universe.SimpleUniverse;
import gui.ClosableJFrame;
import j3d.utils.BasicUniverse;
import j3d.utils.Gutils;
import j3d.utils.ShapeCollection;

import javax.media.j3d.*;
import javax.vecmath.Point3d;
import java.awt.*;


/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Mar 30, 2004
 * Time: 3:08:11 PM
 */
public class Shape3dTest extends ClosableJFrame {
    BranchGroup bg() {
        BranchGroup objectRoot = new BranchGroup();
        TriangleArray ta = new
                TriangleArray(12, GeometryArray.COORDINATES);
        Point3d coords[] = new Point3d[12];
        //base
        coords[0] = new Point3d(-0.5, -0.5, 0);
        coords[1] = new Point3d(0.5, -0.5, 0);
        coords[2] = new Point3d(0, 0.5, 0);

        //side1
        coords[3] = new Point3d(-0.5, -0.5, 0);
        coords[4] = new Point3d(0.5, -0.5, 0);
        coords[5] = new Point3d(0, 0, 1);

        //side2
        coords[6] = new Point3d(-0.5, -0.5, 0);
        coords[7] = new Point3d(0, 0.5, 0);
        coords[8] = new Point3d(0, 0, 1);
        //side3
        coords[9] = new Point3d(0.5, -0.5, 0);
        coords[10] = new Point3d(0, 0.5, 0);
        coords[11] = new Point3d(0, 0, 1);

        ta.setCoordinates(0, coords);
        Shape3D tetrahedron = new Shape3D(ta);
        objectRoot.addChild(tetrahedron);
        objectRoot.addChild(ShapeCollection.getBarrel());
        return objectRoot;
    }

    public void createScene() {
        GraphicsConfiguration gc
                = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c3d = new Canvas3D(gc);
        Container c = getContentPane();
        c.add(BorderLayout.CENTER, c3d);
        BranchGroup bg = bg();
        Gutils.addLights(bg);
        BasicUniverse universe = new BasicUniverse(c3d,4);
        universe.addBranchGraph(bg);
    }

    public Shape3dTest() {
        super("Terahedron");
        setSize(200, 200);
        createScene();
        show();
    }

    public static void main(String[] args) {
        new Shape3dTest();
    }
}
