package j2d.rotator;

import gui.ClosableJFrame;
import j2d.ImageUtils;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 10, 2004
 * <p/>
 * Time: 7:20:50 PM
 */
public class AffineMediator {
    protected Image image;
    protected final AffineBean affineBean = new AffineBean();
    protected ClosableJFrame controlFrame = new ClosableJFrame("Operations in Descending Order:");
    protected Point2D location = new Point2D.Float(0, 0);
    protected Point2D mousePoint = new Point2D.Double(0, 0);
    private AffineTransform op;
    protected AffineTransform lastTransform = new AffineTransform();
    protected AffineTransform priorTransform = new AffineTransform();
    protected final ImagePanel imagePanel = new ImagePanel();

    protected void getNewImage() {
        image = ImageUtils.getImage();
        //Set the mousePoint to the image center
        mousePoint = new Point(image.getWidth(imagePanel) / 2, image.getHeight(imagePanel) / 2);
    }


    public class ImagePanel extends JPanel {
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D) g;
            Dimension d = getSize();
            g2.setColor(Color.blue);
            g2.fillRect(0, 0, d.width, d.height);
            AffineTransform tr1 = new AffineTransform();
            AffineTransform tr2 = new AffineTransform();
            AffineTransform tr3 = new AffineTransform();

            tr1.translate(-mousePoint.getX(), -mousePoint.getY());
            tr1.concatenate(priorTransform);
            op = affineBean.getOperation();
            op.concatenate(tr1);
            tr2.translate(mousePoint.getX(), mousePoint.getY());
            tr2.concatenate(op);
            tr3.translate(location.getX(), location.getY());
            tr3.concatenate(tr2);

            g2.setTransform(tr3);
            lastTransform = tr3;
            if (image == null) return;
            g2.drawImage(image, 0, 0, this);
        }
    }
}
