package j2d.rotator;

import futils.WriterUtil;
import gui.ClosableJFrame;
import gui.run.*;
import ip.ppm.WritePPM;
import j2d.ShortImageBean;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;

/**
 * Created by IntelliJ IDEA.
 * User: David Pavlik
 * Date: May 8, 2004
 * Time: 1:48:30 PM
 */
public class AffineImageController
        implements MouseListener {
    private final AffineMediator affineMediator = new AffineMediator();
    private ClosableJFrame imageFrame ;
    private boolean rotateAboutMouse = false;
    private JPanel labelPanel = getLabelPanel();
    private JPanel sliderPanel = getSliderPanel();
    private RunSlider translateX, translateY,
    rotate, scaleX, scaleY, shearX, shearY;


    public AffineImageController() {
        affineMediator.getNewImage();
        affineMediator.imagePanel.addMouseListener(this);
        displayControlFrame();
        imageFrame =  getDisplayFrame();
    }

    private void displayControlFrame() {
        Container c = affineMediator.controlFrame.getContentPane();
        c.setLayout(new BorderLayout());
        affineMediator.controlFrame.setSize(350, 400);
        c.add(labelPanel, BorderLayout.WEST);
        c.add(sliderPanel, BorderLayout.CENTER);
        affineMediator.controlFrame.show();
    }

    private ClosableJFrame getDisplayFrame() {
        ClosableJFrame imageFrame = new ClosableJFrame();
        Container c = imageFrame.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(getMenuBar(), BorderLayout.NORTH);
        c.add(affineMediator.imagePanel, BorderLayout.CENTER);
        int w = affineMediator.image.getWidth(affineMediator.imagePanel);
        int h = affineMediator.image.getHeight(affineMediator.imagePanel);
        imageFrame.setSize(w * 2, h * 2);
        imageFrame.show();
        return imageFrame;
    }

    private JMenuBar getMenuBar() {
        RunMenuBar mb = new RunMenuBar();
        mb.add(getFileMenu());
        mb.add(getAffineMenu());

        return mb;
    }

    private RunMenu getFileMenu() {
        RunMenu rm = new RunMenu("[File");
        rm.add(new RunMenuItem("[Open... {ctrl O}") {
            public void run() {
                imageFrame.dispose();
                initializeSettings();
                affineMediator.getNewImage();
                imageFrame = getDisplayFrame();
            }
        });
        JMenu saveAs = new JMenu("Save as... ");
        saveAs.setMnemonic(KeyEvent.VK_S);
        rm.add(saveAs);

        saveAs.add(new RunMenuItem("[GIF...(not 24 bit!)") {
            public void run() {
                saveAsGif();
            }
        });
        saveAs.add(new RunMenuItem("[PPM...") {
            public void run() {
                saveAsPPM();
            }
        });
        rm.add(new RunMenuItem("[Exit {ctrl E}") {
            public void run() {
                System.exit(0);
            }
        });

        return rm;
    }

    private void initializeSettings() {
        //setSlidersToZero();
        affineMediator.priorTransform = new AffineTransform();
    }

    private void saveAsGif() {
        String fn = WriterUtil.getSaveFileName("Save as GIF");
        if (fn == null) return;
        saveAsGif(fn);
    }

    private void saveAsGif(String fn) {
        try {
            ip.vs.WriteGIF.DoIt(affineMediator.image, fn + ".gif");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveAsPPM() {
        String fn = WriterUtil.getSaveFileName("Save as PPM");
        if (fn == null) return;
        saveAsPPM(fn);
    }

    private void saveAsPPM(String fn) {
        ShortImageBean shortImageBean = new ShortImageBean();
        shortImageBean.setImage(affineMediator.image);
        WritePPM.doIt(shortImageBean.getR(), shortImageBean.getG(), shortImageBean.getB(), fn + ".ppm");
    }

    private RunMenu getAffineMenu() {
        RunMenu rm = new RunMenu("[Affine Menu");
        rm.add(new RunCheckBoxMenuItem("[Rotate About Mouse {ctrl R}") {
            public void run() {
                rotateAboutMouse = super.getState();
                if (!rotateAboutMouse) {
                    //Finalize the location of the lastTransform and make available as priorTransform
                    final AffineTransform fixedLastTransform = affineMediator.lastTransform;
                    affineMediator.priorTransform = fixedLastTransform;
                    //Set the mousePoint to the image center going through the priorTransform
                    affineMediator.mousePoint = affineMediator.priorTransform.transform(
                            new Point(affineMediator.image.getWidth(affineMediator.imagePanel) / 2, affineMediator.image.getHeight(affineMediator.imagePanel) / 2), null);
                    //setSlidersToZero();
                }
            }
        });

        return rm;
    }

    public JPanel getLabelPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        //Labels are added to the panel in the order they occur in the vector
        JLabel sliderLabels[] = affineMediator.affineBean.getSliderLabels();
        for (int i = 0; i < 7; i++) {

            jp.add(sliderLabels[i]);
        }

        return jp;
    }

    private JPanel getSliderPanel() {
        RunSlider sliders[] = getInitialSliders(this);
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        for (int i = 0; i < 7; i++) {
            jp.add(sliders[i]);
        }
        return jp;
    }

    private static RunSlider[] getInitialSliders(
            final AffineImageController affineImageController) {

        affineImageController.translateX = new RunSlider(-300, 300, 0) {
            public void run() {
                affineImageController.translateX(getValue());
            }
        };
        affineImageController.translateY = new RunSlider(-300, 300, 0) {
            public void run() {
                affineImageController.translateY(getValue());
            }
        };
        affineImageController.rotate = new RunSlider(-180, 180, 0) {
            public void run() {
                affineImageController.rotate(getValue());
            }
        };
        affineImageController.scaleX = new RunSlider(0, 200, 100) {
            public void run() {
                affineImageController.scaleX(getValue() / 100.0);
            }
        };
        affineImageController.scaleY = new RunSlider(0, 200, 100) {
            public void run() {
                affineImageController.scaleY(getValue() / 100.0);
            }
        };
        affineImageController.shearX = new RunSlider(-400, 400, 0) {
            public void run() {
                affineImageController.shearX(getValue() / 100.0);
            }
        };
        affineImageController.shearY = new RunSlider(-400, 400, 0) {
            public void run() {
                affineImageController.shearY(getValue() / 100.0);
            }
        };


        RunSlider rs[] = {
            affineImageController.translateX, affineImageController.translateY,
            affineImageController.rotate,
            affineImageController.scaleX, affineImageController.scaleY,
            affineImageController.shearX, affineImageController.shearY
        };

        return rs;
    }



    private void translateX(int x) {
        affineMediator.location.setLocation(x, affineMediator.location.getY());
        affineMediator.imagePanel.repaint();
    }

    private void translateY(int y) {
        affineMediator.location.setLocation(affineMediator.location.getX(), y);
        affineMediator.imagePanel.repaint();
    }

    private void scaleX(double sx) {
        affineMediator.affineBean.getScale().setLocation(sx, affineMediator.affineBean.getScale().getY());
        affineMediator.imagePanel.repaint();
    }

    private void scaleY(double sy) {
        affineMediator.affineBean.getScale().setLocation(
                affineMediator.affineBean.getScale().getX(), sy);
        affineMediator.imagePanel.repaint();
    }

    private void shearX(double sx) {
        affineMediator.affineBean.getShear().setLocation(sx, affineMediator.affineBean.getShear().getY());
        affineMediator.imagePanel.repaint();
    }

    private void shearY(double sy) {
        affineMediator.affineBean.getShear().setLocation(
                affineMediator.affineBean.getShear().getX(), sy);
        affineMediator.imagePanel.repaint();
    }

    private void rotate(double radians) {
        affineMediator.affineBean.setTheta(radians);
        affineMediator.imagePanel.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (!rotateAboutMouse) return;
        //Finalize the location of the lastTransform and make available as priorTransform
        final AffineTransform fixedPriorTransform = affineMediator.lastTransform;
        affineMediator.priorTransform = fixedPriorTransform;

        affineMediator.mousePoint = e.getPoint();
        //setSlidersToZero();
        affineMediator.imagePanel.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

}

