package j2d.rotator;

import javax.swing.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 10, 2004
 * <p/>
 * Time: 6:26:35 PM
 */
public class AffineBean {
    private JLabel[] sliderLabels = new JLabel[]{new JLabel("Translate X"),
                                       new JLabel("Translate Y"),
                                       new JLabel("Rotate"),
                                       new JLabel("Scale X"),
                                       new JLabel("Scale Y"),
                                       new JLabel("Shear X"),
                                       new JLabel("Shear Y")};

    private Point2D scale = new Point2D.Double(1.0, 1.0);
    private Point2D shear = new Point2D.Double(0, 0);
    private double theta = 0;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    // The listener list wrapper methods
    public synchronized void addPropertyChangeListener(
            PropertyChangeListener pcl) {
        pcs.addPropertyChangeListener(pcl);
    }


    public AffineTransform getOperation() {
        AffineTransform at = new AffineTransform();

        for (int i = 0; i < 7; i++) {
            final JLabel sl = sliderLabels[i];
            if (sl.getText() ==
                    "Rotate")
                at.rotate(theta * Math.PI / 180);
            if (sl.getText() ==
                    "Scale X")
                at.scale(scale.getX(), 1);
            if (sl.getText() ==
                    "Scale Y")
                at.scale(1, scale.getY());
            if (sl.getText() ==
                    "Shear X")
                at.shear(shear.getX(), 0);
            if (sl.getText() ==
                    "Shear Y")
                at.shear(0, shear.getY());
        }

        return at;
    }

    public JLabel[] getSliderLabels() {
        return sliderLabels;
    }

    public Point2D getScale() {
        return scale;
    }

    public void setScale(Point2D scale) {
        this.scale = scale;
        pcs.firePropertyChange("AffineTransform", null, getOperation());
    }

    public Point2D getShear() {
        return shear;
    }

    public void setShear(Point2D shear) {
        this.shear = shear;
        pcs.firePropertyChange("AffineTransform", null, getOperation());
    }

    public double getTheta() {
        return theta;

    }

    public void setTheta(double theta) {
        this.theta = theta;
        pcs.firePropertyChange("AffineTransform", null, getOperation());
    }
}
