package j2d.hpp;


public class HppTransformTable {
    private short lutR[] = new short[256];
    private short lutG[] = new short[256];
    private short lutB[] = new short[256];

    public HppTransformTable(HppFilterInterface f) {
        for (int i = 0; i < 256; i++) {
            lutR[i] = (short) (f.getR(i) & 0XFF);
            lutG[i] = (short) (f.getG(i) & 0XFF);
            lutB[i] = (short) (f.getB(i) & 0XFF);
        }
    }


    public void applyLut(short r[][], short g[][], short b[][]) {
        int w = r.length;
        int h = r[0].length;

        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                r[x][y] = lutR[r[x][y]];
                g[x][y] = lutG[g[x][y]];
                b[x][y] = lutB[b[x][y]];
            }
    }

    public void print() {
        for (int i = 0; i < lutR.length; i++) {
            System.out.println(i
                    + '\t' + lutR[i]
                    + '\t' + lutG[i]
                    + '\t' + lutB[i]);
        }
    }
}