/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 1, 2003
 * Time: 9:45:14 AM
 */
package j2d.hpp;

import j2d.ImageUtils;
import j2d.ImageProcessorInterface;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;

public class HppFilterImageProcessor
        implements ImageProcessorInterface {
    private HppFilterInterface f = null;
    short lut[][] = new short[3][256];

    public HppFilterImageProcessor(HppFilterInterface _f) {
        f = _f;
        for (int v = 0; v < 256; v++) {
            lut[0][v] = f.getR(v);
            lut[1][v] = f.getG(v);
            lut[2][v] = f.getB(v);
        }
    }

    public static Image getImage(Image img, HppFilterInterface f) {
        HppFilterImageProcessor hbi = new HppFilterImageProcessor(f);
        return hbi.process(img);
    }

    public Image process(Image img) {
        return ImageUtils.getImage(
                process(
                        ImageUtils.getBufferedImage(img)));
    }

    public BufferedImage process(BufferedImage image) {
        // create filter to invert colors
        BufferedImageOp bio = new LookupOp(
                new ShortLookupTable(0, lut), null);

        // apply filter to displayImage
        return bio.filter(image, null);

    }
}
