package j2d.gui;

import gui.run.RunMenu;
import gui.run.RunMenuItem;
import j2d.ShortImageBean;
import j2d.edge.*;
import j2d.color.ColorizerPanel;
import j2d.filters.GaussianPanel;
import j2d.hpp.*;

import javax.swing.*;
import java.awt.*;

import bookExamples.ch26Graphics.draw2d.DrawComponent;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 24, 2005
 * Time: 2:34:13 PM
 * Copyright DocJava, 2005
 */
public class MainMenus {
    public static void addFileMenu(final Main main, JMenuBar mb) {
        RunMenu fileMenu = new RunMenu("[File");
        mb.add(fileMenu);

        fileMenu.add(new RunMenuItem("[Open{ctrl O}",
                Hex.getOpenIcon()) {
            public void run() {
                main.openImage();
            }
        });

        fileMenu.add(new RunMenuItem("[Capture screen{alt 4}",
                Hex.getCaptureIcon()) {
            public void run() {
                main.captureScreen();
            }
        });
        fileMenu.add(new RunMenuItem("C[apture camera{alt C}",
                Hex.getCaptureIcon()) {
            public void run() {
                main.captureVideo();
            }
        });
        fileMenu.add(new RunMenuItem("[Revert{ctrl W}",
                Hex.getRevertIcon()) {
            public void run() {
                main.revertImage();
            }
        });
        fileMenu.add(new RunMenuItem("[Save{ctrl S}",
                Hex.getSaveIcon()) {
            public void run() {
                main.saveImage();
            }
        });
        fileMenu.add(new RunMenuItem("[Print Hex{ctrl h}") {
            public void run() {
                main.printHexImage();
            }
        });

        fileMenu.add(new RunMenuItem("E[xit{ctrl Q}",
                Hex.getExitIcon()) {
            public void run() {
                main.shutdown();
            }
        });
    }

    public static RunMenu getEdgeMenu(final Main main) {
        RunMenu rm = new RunMenu("[Edge");
        // to do add edge panels here
        rm.add(new RunMenuItem("[Canny{alt ctrl c}") {
            public void run() {
                main.addPanel(new CannyPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[LoGSobel{alt ctrl s}") {
            public void run() {
                main.addPanel(new LoGSobelPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[MagDOG{alt ctrl d}") {
            public void run() {
                main.addPanel(new MagDOGPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[Sobel{alt ctrl o}") {
            public void run() {
                main.addPanel(new SobelPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("MehrotraAnd[Zhang{alt ctrl z}") {
            public void run() {
                main.addPanel(new MehrotraAndZhangPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[Template{alt ctrl t}") {
            public void run() {
                main.addPanel(new TemplatePanel(main), getText());
            }
        });//
        return rm;
    }

    public static RunMenu getBlurMenu(final Main main) {
        RunMenu rm = new RunMenu("[Blur");
        // to do add edge panels here
        rm.add(new RunMenuItem("[GaussianPanel{alt ctrl G}") {
            public void run() {
                GaussianPanel cp = new GaussianPanel(main);
                main.addPanel(cp, getText());
            }
        });
        return rm;
    }

    public static RunMenu getFilterMenu(final Main main) {
        RunMenu rm = new RunMenu("F[ilter");
        rm.add(getEdgeMenu(main));
        rm.add(getBlurMenu(main));
        return rm;
    }

    public static RunMenu getHistogramMenu(final Main main) {
        RunMenu processMenu = new RunMenu("[Histogram");
        processMenu.add(new RunMenuItem("H[istogram Panel{ctrl i}") {
            public void run() {
                HistogramPanel cp = new HistogramPanel(main);
                main.addPanel(cp, getText());
            }
        });
        processMenu.add(new RunMenuItem("[Exponential Stretch") {
            public void run() {
                if (main.estStretchControls == null ||
                        main.estStretchControls.isClosed()) {
                    main.launchStretchControls();
                }
            }
        });
        processMenu.add(new RunMenuItem("[ContrastPanel{alt ctrl C}") {
            public void run() {
                ContrastPanel cp = new ContrastPanel(main);
                main.addPanel(cp, getText());
            }
        });

        return processMenu;
    }

    public static RunMenu getColorMenu(final Main main) {
        RunMenu processMenu = new RunMenu("[Color");
        processMenu.add(new RunMenuItem("Pse[udoColorFilter") {
            public void run() {
                main.addPanel(new ColorizerPanel(main), getText());
            }
        });
        processMenu.add(new RunMenuItem("gray") {
            public void run() {
                Image img = main.getImage();
                ShortImageBean sib = new ShortImageBean(img);
                sib.gray();
                main.setImage(sib.getImage());
            }
        });
        processMenu.add(new RunMenuItem("[negate{ctrl C}") {
            public void run() {
                main.process(new InvertFilter());
            }
        });
        return processMenu;
    }

    public static void addProcessMenu(final Main main, JMenuBar mb) {
        RunMenu processMenu = new RunMenu("[process");
        processMenu.add(getHistogramMenu(main));
        processMenu.add(getColorMenu(main));
        processMenu.add(getFilterMenu(main));
        processMenu.add(getDrawMenu(main));
        mb.add(processMenu);
        processMenu.add(new RunMenuItem("[Apply{control A}") {
            public void run() {
                main.apply();
            }
        });
        processMenu.add(new RunMenuItem("GreyHppFilter3Panel") {
            public void run() {
                main.addPanel(new GreyHppFilter3Panel(main), getText());
            }
        });

        processMenu.add(new RunMenuItem("ThresholdFilter3Panel") {
            public void run() {
                main.addPanel(new ThresholdFilter3Panel(main), getText());
            }
        });
        processMenu.add(new RunMenuItem("ThresholdPanel") {
            public void run() {
                main.addPanel(new ThresholdPanel(main), getText());
            }
        });
        //
        processMenu.add(new RunMenuItem("salt and pepper 1000") {
            public void run() {
                Image img = main.getImage();
                ShortImageBean sib = new ShortImageBean(img);
                sib.saltAndPepper(1000);
                main.setImage(sib.getImage());
            }
        });

    }

    private static RunMenu getDrawMenu(Main main) {
        RunMenu rm = new RunMenu("[Draw");
        rm.add(new RunMenuItem("start draw program"){
            public void run(){
                DrawComponent.main(null);
            }
        });
        return rm;
    }
}
