// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

import javax.swing.*;
import java.awt.*;

/**
 * MDI child frame for displaying an image
 */
public class InternalImageFrame extends JInternalFrame {
    private ImagePanel imagePanel = new ImagePanel();
    private Image baseImage;

    /**
     * Construct a new frame with the specified base image and
     * title.
     *
     * @param img   The base image.  This is the intially displayed
     *              image and the one on which signal processing is
     *              performed.
     * @param title Text for the frame's title bar
     */
    public InternalImageFrame(Image img, String title) {
        imagePanel = new ImagePanel();
        imagePanel.setImage(img);
        baseImage = img;
        JScrollPane jsp = new JScrollPane();
                jsp.setViewportView(imagePanel);
        setTitle(title);

        setImage(img);

        Container c = getContentPane();
        c.setLayout(new BorderLayout());
        c.add(jsp, BorderLayout.CENTER);

        setMinimumSize(new Dimension(100, 100));
        setClosable(true);
        setMaximizable(true);
        setResizable(true);
    }

    /**
     * Obtain a handle to the base image.
     */
    public Image getBaseImage() {
        return baseImage;
    }
    /**
     * Call this method when you want to copy the
     * processed image into the base image for the next
     * operation.
     * @param image
     */
    public void setBaseImage(Image image){
        baseImage = image;
    }

    /**
     * Return a reference to the displayed image.
     */
    public Image getDisplayedImage() {
        return imagePanel.getImage();
    }
    public void apply() {
        baseImage = getDisplayedImage();
    }
    /**
     * Display the base image.
     */
    public void revert() {
        imagePanel.setImage(baseImage);
    }
    /**
     * set the displayed image, but do not change
     * the base image.
     * @param image
     */
    public void setImage(Image image) {
        if (image==null) System.out.println("img==null!");
        if (imagePanel == null) System.out.println("ipnDisplay==null!");
        imagePanel.setImage(image);
    }
}