package j2d.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class Hex {
    public static Icon getOpenIcon() {
        return new ImageIcon(getImage(open, 16, 16), "open");
    }

    public static Icon getSaveIcon() {
        return new ImageIcon(getImage(save, 16, 16), "save");
    }

    public static Icon getCaptureIcon() {
        return new ImageIcon(getImage(capture, 16, 16), "capture");
    }

    public static Icon getRevertIcon() {
        return new ImageIcon(getImage(revert, 16, 16), "revert");
    }

    public static Image getImage(int pels[], int width, int height) {
        Toolkit tk =
                Toolkit.getDefaultToolkit();
        ColorModel cm = tk.getColorModel();

        return tk.createImage(new
                MemoryImageSource(width,
                        height,
                        cm,
                        pels, 0,
                        width));
    }

    private static int save[] = {
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xd6d6ce, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
    };
    private static int revert[] = {
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,

    };
    private static int capture[] = {
        16, 16, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff848484, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff848484, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff848484, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff848484, 0xd6d6ce, 0xff008400, 0xff848484, 0xd6d6ce,
        0xff848484, 0xff008400, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484,
        0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff008400, 0xff848484, 0xff008400, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xffffffff, 0xff848484, 0xff008400, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xffffffff, 0xffffffff, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xffffffff, 0xd6d6ce, 0xffffffff, 0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xffffffff, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
    };

    public static Icon getExitIcon() {
        return new ImageIcon(getImage(exit, 16, 16), "exit");
    }

    private static int exit[] = {
        0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff424242,
        0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242,
        0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7,
    };


    private static int open [] = {
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xffd6d6ce, 0xff000000, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce,
        0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce,
        0xff000000, 0xffffffff, 0xffffff00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff000000, 0xffffffff, 0xffffff00, 0xffffffff, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xffd6d6ce,
        0xff000000, 0xffffff00, 0xffffffff, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xffffffff, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce};
}
