package j2d.graphics;

import gui.ClosableJFrame;
import gui.run.RunSlider;
import j2d.ImageUtils;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class AffineImagePanel extends JPanel {
    double theta = 30;
    Point2D location = new Point2D.Float(20, 30);
    Point2D scale = new Point2D.Float(0.5f, 0.5f);
    Point2D shear = new Point2D.Float(.2f,0f);
    Image image = ImageUtils.getImage();

    public static void main(String args[]) {
        new AffineImagePanel();
    }

    AffineImagePanel() {
        displayAffineImageFrame();
    }

    public void displayAffineImageFrame() {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(this, BorderLayout.CENTER);
        c.add(getControlPanel(), BorderLayout.SOUTH);
        cf.setSize(200, 200);
        cf.show();
    }

    public JPanel getControlPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(new RunSlider(0, 360) {
            public void run() {
                rotate(getValue());
            }
        });
        jp.add(new RunSlider(0, 100) {
            public void run() {
                translateX(getValue());
            }
        });
        jp.add(new RunSlider(0, 100) {
            public void run() {
                translateY(getValue());
            }
        });
        jp.add(new RunSlider(-100, 100) {
            public void run() {
                scaleX(getValue() / 100.0);
            }
        });
        jp.add(new RunSlider(-100, 100) {
            public void run() {
                scaleY(getValue() / 100.0);
            }
        });
        jp.add(new RunSlider(-100, 100) {
            public void run() {
                shearX(getValue() / 100.0);
            }
        });
        jp.add(new RunSlider(-100, 100) {
            public void run() {
                shearY(getValue() / 100.0);
            }
        });
        return jp;
    }

    public void translateX(int x) {
        location.setLocation(x, location.getY());
        repaint();
    }

    public void translateY(int y) {
        location.setLocation(location.getX(), y);
        repaint();
    }

    public void scaleX(double sx) {
        scale.setLocation(sx, location.getY());
        repaint();
    }

    public void scaleY(double sy) {
        scale.setLocation(location.getX(), sy);
        repaint();
    }

    public void shearX(double sx) {
        shear.setLocation(sx, location.getY());
        repaint();
    }

    public void shearY(double sy) {
        shear.setLocation(location.getX(), sy);
        repaint();
    }

    public void rotate(double radians) {
        theta = radians;
        repaint();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        drawImage(g2, scale.getX(), scale.getY(), location, theta);
    }

    /**
     * Rotate the arrow using degrees for the angle.
     *
     * @param g2
     * @param sx
     * @param sy
     * @param location
     * @param angle
     */
    private void drawArrow(Graphics2D g2,
                           float sx, float sy,
                           Point2D location,
                           double angle) {
        GeneralPath gp = getArrow();
        //erase(g2, gp);
        setUpAffineTransform(location, sx, sy, g2, angle);
        g2.draw(gp);
    }

    private void drawImage(Graphics2D g2,
                           double sx, double sy,
                           Point2D location,
                           double angle) {
        Dimension d = getSize();
        g2.fillRect(0, 0, d.width, d.height);

        g2.translate(location.getX(), location.getY());
        g2.rotate(angle*Math.PI/180.0);
        g2.shear(shear.getX(), shear.getY());
        g2.scale(scale.getX(), scale.getY());
        g2.drawImage(image, 0, 0, this);
    }


    private void setUpAffineTransform(Point2D location, float sx, float sy, Graphics2D g2, double angle) {
        AffineTransform at = new AffineTransform();
        //at.shear(shear.getX(), shear.getY());
        at.setToTranslation(location.getX(), location.getY());
        at.scale(sx, sy);

        at.rotate(angle * Math.PI / 180, 10, 10);

        g2.setTransform(at);

        //g2.setTransform(at);
    }


    private void erase(Graphics2D g2, GeneralPath gp) {
        g2.setXORMode(getBackground());
        g2.draw(gp);
        g2.setXORMode(getForeground());
    }


    private GeneralPath getArrow() {
        GeneralPath gp = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
        gp.moveTo(0f, -15f);
        gp.lineTo(10f, 5f);
        gp.lineTo(5f, 5f);
        gp.lineTo(5f, 15f);
        gp.lineTo(-5, 15f);
        gp.lineTo(-5f, 5f);
        gp.lineTo(-10f, 5f);
        gp.closePath();
        return gp;
    }
}
