// BlurFilter.java
// Blurfilter is an Java2DImageFilter that blurs a BufferedImage.
package j2d.filters;

import j2d.ImageUtils;
import ip.transforms.BufferedImageProcessor;

import java.awt.image.BufferedImage;

public class BlurFilter implements BufferedImageProcessor {

    // apply blurring filter to BufferedImage
    public BufferedImage process(BufferedImage bi) {
        // array used to blur BufferedImage
        float[][] blurMatrix = {
            {1.0f / 9.0f, 1.0f / 9.0f, 1.0f / 9.0f},
            {1.0f / 9.0f, 1.0f / 9.0f, 1.0f / 9.0f},
            {1.0f / 9.0f, 1.0f / 9.0f, 1.0f / 9.0f}};

        return ImageUtils.convolve(bi, blurMatrix);

    } // end method processImage

}