package j2d;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.TIFFEncodeParam;
import futils.Futil;
import futils.StreamSniffer;
import futils.WriterUtil;
import graphics.NumImage;
import gui.ClosableJFrame;
import gui.ImageBeanInterface;
import gui.In;
import ip.ppm.WritePPM;
import ip.transforms.Kernels;
import j2d.color.PseudoColorFilter;
import j2d.filters.GaussianSmoothingProcessor;
import j2d.hpp.*;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.*;
import java.io.*;
import java.util.zip.GZIPOutputStream;

import utils.ResourceManager;

// ...

/**
 * A toolkit of useful image processing methods.
 * Declared as final, since all methods are static.
 */
public final class ImageUtils {
    /**
     * make it so no one will instance this class.
     */
    private ImageUtils() {
    }
    /**
     * Do a bilinear inverse affine transform and throw
     * and exception if the xform is not invertable.
     * @param scalex scale about transx and transy
     * @param scaley
     * @param shearx shear about transx and transy
     * @param sheary
     * @param transx point about which xform is performed
     * @param transy
     * @param radians rotation
     * @param bi
     * @return transformed image.
     */
    public static BufferedImage affineXform(double scalex, double scaley,
                                            double shearx, double sheary,
                                            double transx, double transy,
                                            double radians,
                                            BufferedImage bi){
        AffineTransform tx = new AffineTransform();
        tx.scale(scalex, scaley);
        tx.shear(shearx, sheary);
        tx.translate(transx, transy);
        tx.rotate(radians,
                bi.getWidth() / 2,
                bi.getHeight() / 2);

        AffineTransformOp op = new AffineTransformOp(tx,
                AffineTransformOp.TYPE_BILINEAR);
        return op.filter(bi, null);
    }

    public static void saveAsPPMgz(Image img, String fn) {
        ShortImageBean sib = new ShortImageBean(img);
        WritePPM wppm = new WritePPM(sib.getWidth(), sib.getHeight());
        try {
            GZIPOutputStream
                    os = new GZIPOutputStream(new FileOutputStream(fn));
            wppm.writeHeader(os);
            wppm.writeImage(os, sib.getR(), sib.getG(), sib.getB());
            os.finish();
            os.close();
        } catch (Exception e) {
            System.out.println("Save PPM Exception - 2!");
        }
    }

    public static void saveAsPPMgz(Image img) {
        String fn = WriterUtil.getSaveFileName("Save as PPM.gz");
        if (fn == null) return;
        saveAsPPMgz(img, fn);
    }

    public static void saveAsPPM(Image img, File f) {
        ShortImageBean sib = new ShortImageBean(img);
        WritePPM.doIt(sib.getR(),
                sib.getG(),
                sib.getB(),
                f.toString());
    }

    public static void printImageWriterFormats() {
        //print(ImageIO.getWriterFormatNames());
    }

    public static void printImageReaderFormats() {
        String s[] = null; //ImageIO.getReaderFormatNames();
        print(s);
    }

    public static void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    public static java.awt.Image getImage(java.awt.Component c) {
        java.awt.Dimension d = c.getSize();
        java.awt.Frame f = new java.awt.Frame();
        f.addNotify();
        f.setSize(d);
        java.awt.Image i = f.createImage(d.width, d.height);

        c.paint(i.getGraphics());
        return i;
    }

    public static void testGetImage() {
        ClosableJFrame cjf = new ClosableJFrame("test image");
        Container c = cjf.getContentPane();
        c.setLayout(new GridLayout(1, 0));
        c.add(new imagePanel(getImage()));
        c.add(new imagePanel(getImage()));
        c.add(new imagePanel(getImage()));
        c.add(new imagePanel(getImage()));
        cjf.setSize(200, 200);
        cjf.show();
    }

    public static java.awt.Image getImage() {
        java.io.File f =
                Futil.getReadFile("select an image");
        if (f == null) return null;
        InputStream is = null;
        try {
            is = new FileInputStream(f);
            new StreamSniffer(is);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return getGifJpgPngImage(f);
    }

    public static Image getImage(String fn) {

        File f = new File(fn);
        if (f.exists()) {
            final int imageType = StreamSniffer.getImageType(f);

            if (isGifPngOrJpg(imageType))
                return getGifJpgPngImage(f);
            else if(isPpm(imageType))
                return getPpmImage(f);
            else In.message("format not supported");
        }
        In.message(f+" not found ImageUtils.getImage,using cameraman image");
        return NumImage.getImage();
    }

    private static Image getPpmImage(File f) {
        ShortImageBean sib = null;
        try {
            sib = ShortImageBean.readPpm(f);
        } catch (IOException e) {
            In.message(e);

        }
        return sib.getImage();

    }

    private static boolean isPpm(int streamClass) {
        if (streamClass == StreamSniffer.PPM_RAWBITS) return true;
        if (streamClass == StreamSniffer.PPM) return true;
        return false;
    }

    private static boolean isGifPngOrJpg(int i) {
        if (i == StreamSniffer.GIF87a) return true;
        if (i == StreamSniffer.GIF89a) return true;
        if (i == StreamSniffer.PNG_IMAGE) return true;
        if (i == StreamSniffer.JPEG) return true;
        if (i == StreamSniffer.JPG) return true;
        return false;
    }

    public static java.awt.Image getGifJpgPngImage(java.io.File f) {
        java.awt.Image i =
                java.awt.Toolkit.getDefaultToolkit().getImage(f.toString());
        waitForImage(new gui.ClosableJFrame(), i);
        System.out.println("getGifJpgPngImage returns");
        return i;
    }
    public Image getGifOrJpg(File imageFile) {
        return Toolkit.getDefaultToolkit()
                .getImage(imageFile.getAbsolutePath());
    }
    public static void waitForImage(java.awt.Component c,
                                    java.awt.Image image) {
        if (c == null) waitForImage(image);
        if (image == null) System.out.println("Image is Null!");
        java.awt.MediaTracker tracker = new java.awt.MediaTracker(c);
        try {
            if (image == null) In.message("Image is null!");
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        } catch (Exception e) {
            In.message(e);
        }
    }

    public static void waitForImage(java.awt.Image image) {
        JPanel jp = new JPanel();
        waitForImage(jp, image);
    }

    public static Image byte2Image(byte r[][]) {

        int w = r.length;
        int h = r[0].length;
        int v = 0;
        Toolkit tk = Toolkit.getDefaultToolkit();
        int pels[] = new int[w * h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                if (r[x][y] == 1)
                    v = 255;
                else
                    v = 0;
                pels[y + x * h] =
                        0xff000000
                        | (v << 16)
                        | (v << 8)
                        | v;
            }
        Image i = tk.createImage(new MemoryImageSource(w,
                h,
                ColorModel.getRGBdefault(),
                pels, 0,
                w));
        return i;
    }

    public static Image short2Image(short r[][]) {

        int w = r.length;
        int h = r[0].length;
        int v = 0;
        Toolkit tk = Toolkit.getDefaultToolkit();
        int pels[] = new int[w * h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                v = r[x][y];
                pels[y + x * h] =
                        0xff000000
                        | (v << 16)
                        | (v << 8)
                        | v;
            }
        Image i = tk.createImage(new MemoryImageSource(w,
                h,
                ColorModel.getRGBdefault(),
                pels, 0,
                w));
        return i;
    }


    public static Image getImage(short r[][], short g[][], short b[][],
                                 HppFilterInterface f) {

        int w = r.length;
        int h = r[0].length;

        return getImage(getPels(r, g, b, f),
                w, h);
    }

    public static Image getImage(short r[][], HppFilterInterface f) {
        int w = r.length;
        int h = r[0].length;
        return getImage(getPels(r, f),
                w, h);
    }

    private static int[] getPels(short[][] r, HppFilterInterface f) {
        int w = r.length;
        int h = r[0].length;

        int pels[] = new int[w * h];
        int v;
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                v = r[x][y];
                pels[y + x * h] =
                        packInt(f.getR(v),
                                f.getG(v),
                                f.getB(v));
            }
        return pels;
    }

    public static int[] short2Pels(short r[][], short g[][], short b[][]) {
        int width = r.length;
        int height = r[0].length;
        int pels[] = new int[width * height];
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++)
                pels[x + y * width]
                        = packInt(r[x][y],
                                g[x][y],
                                b[x][y]);
        return pels;
    }

    /**
     * Get the red part of a packed rgb int.
     *
     * @param rgb a pixel in argb format
     * @return just the red part.
     */
    public static final short getRed(int rgb) {
        return (short) ((rgb & 0xFF0000) >> 16);
    }

    /**
     * Get the green part of a packed rgb int
     *
     * @param rgb a pixel in argb format
     * @return just the green part.
     */
    public static final short getGreen(int rgb) {
        return (short) ((rgb & 0x00FF00) >> 8);
    }

    /**
     * Get the blue part of a packed rgb int.
     *
     * @param rgb a pixel in argb format
     * @return just the blue part
     */
    public static final short getBlue(int rgb) {
        return (short) ((rgb & 0x0000FF));
    }

    /**
     * Adapter design pattern
     *
     * @param f a standard RGBImageFilter
     * @return HppFilter3 Homogenious point processor
     */
    public static HppFilter3Interface getHppFilter3(final RGBImageFilter f) {
        return new HppFilter3Interface() {
            public short getR(int r, int g, int b) {
                return getRed(f.filterRGB(0, 0, ImageUtils.packInt(r, g, b)));
            }

            public short getG(int r, int g, int b) {
                return getGreen(f.filterRGB(0, 0, ImageUtils.packInt(r, g, b)));
            }

            public short getB(int r, int g, int b) {
                return getBlue(f.filterRGB(0, 0, ImageUtils.packInt(r, g, b)));
            }
        };
    }

    public static RGBImageFilter getRGBImageFilter(final HppFilter3Interface f) {
        return new RGBImageFilter() {
            public int filterRGB(int x, int y, int rgb) {
                Color c = new Color(rgb);
                int r = c.getRed();
                int g = c.getGreen();
                int b = c.getBlue();
                return packInt(f.getR(r, g, b),
                        f.getB(r, g, b),
                        f.getG(r, g, b));
            }
        };
    }

    private static int[] getPels(short r[][], short g[][], short b[][], HppFilterInterface f) {
        int w = r.length;
        int h = r[0].length;
        int pels[] = new int[w * h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++)
                pels[y + x * h] =
                        packInt(f.getR(r[x][y]),
                                f.getG(g[x][y]),
                                f.getB(b[x][y]));
        return pels;
    }

    /**
     * Return an int packed as ARGB
     *
     * @param r red component (0..255)
     * @param g green component (0..255)
     * @param b blue component (0..255)
     * @return the packed int.
     */
    public static final int packInt(int r, int g, int b) {
        return 0xFF000000
                | ((0xFF & r) << 16)
                | ((0xFF & g) << 8)
                | (0xFF & b);
    }

    /**
     * Get a convole operator instance from a <code>Kernel</code>
     * instance.
     *
     * @param k The <code> kernel</code>instance
     * @return an instance of a <code>ConvolveOp</code>.
     */
    public static ConvolveOp getConvolveOp(Kernel k) {
        ConvolveOp convolveOp = new ConvolveOp(k, ConvolveOp.EDGE_ZERO_FILL, null);
        return convolveOp;
    }

    public static Kernel makeKernel(int w, int h, float blurMatrix[]) {
        return new Kernel(w, h, blurMatrix);
    }

    public static Kernel makeKernel(float k2d[][]) {
        int w = k2d.length;
        int h = k2d[0].length;
        float k[] = new float[w * h];
        int x = 0;
        for (int i = 0; i < w; i++)
            for (int j = 0; j < h; j++, x++)
                k[x] = k2d[i][j];
        return new Kernel(w, h, k);
    }

    public static boolean hasAlpha(Image image) {
        // If buffered image, the color model is readily available
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage) image;
            return bimage.getColorModel().hasAlpha();
        }

        // Use a pixel grabber to retrieve the image's color model;
        // grabbing a single pixel is usually sufficient
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        } catch (InterruptedException e) {
        }

        // Get the image's color model
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage getBufferedImage2(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage) image;
        }

        // This code ensures that all the pixels in the image are loaded
        image = new ImageIcon(image).getImage();

        // Determine if the image has transparent pixels; for this method's
        // implementation, see e665 Determining If an Image Has Transparent Pixels
        boolean hasAlpha = hasAlpha(image);
        int w = image.getWidth(null);
        int h = image.getHeight(null);

        // Create a buffered image with a format that's compatible with the screen
        BufferedImage bimage = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            // Determine the type of transparency of the new buffered image
            int transparency = Transparency.OPAQUE;
            if (hasAlpha) {
                transparency = Transparency.BITMASK;
            }

            // Create the buffered image
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        } catch (Exception e) {
            // The system does not have a screen
        }

        if (bimage == null) {
            // Create a buffered image using the default color model
            int type = BufferedImage.TYPE_INT_RGB;
            if (hasAlpha) {
                type = BufferedImage.TYPE_INT_ARGB;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }

        // Copy image to buffered image
        Graphics g = bimage.createGraphics();

        // Paint the image onto the buffered image
        g.drawImage(image, 0, 0, null);
        g.dispose();

        return bimage;
    }


    public static BufferedImage getBufferedImage3(Image img) {
        ImageBean ib = new ImageBean();
        ib.setImage(img);
        return getBufferedImage(ib);
    }

    public static BufferedImage getBufferedImage(Image img) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage bi = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(img, 0, 0, w, h, null);
        return bi;
    }

    public static BufferedImage getBufferedImage(ImageBeanInterface ib) {
        int w = ib.getImageWidth();
        int h = ib.getImageHeight();
        BufferedImage bi = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(ib.getImage(), 0, 0, w, h, null);
        return bi;
    }

    public static ImageBean getImageBean(BufferedImage bi) {
        ImageBean ib = new ImageBean();
        ib.setImage(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(bi.getSource(),
                new BufferedImageFilter(new AffineTransformOp(new AffineTransform(),
                        AffineTransformOp.TYPE_BILINEAR)))));
        return ib;
    }

    public static Image getImage(BufferedImage bi) {
        return
                Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(bi.getSource(),
                        new BufferedImageFilter(new AffineTransformOp(new AffineTransform(),
                                AffineTransformOp.TYPE_BILINEAR))));
    }

    public static ImageBean changeColors(float colorMatrix[][],
                                         ImageBean ib) {
        return getImageBean(changeColors(colorMatrix, getBufferedImage(ib)));
    }

    public static Image changeColors(float colorMatrix[][],
                                     Image img) {
        ImageBean ib = new ImageBean();
        ib.setImage(img);
        ib = changeColors(colorMatrix, ib);

        return ib.getImage();
    }


    public static BufferedImage changeColors(float colorMatrix[][],
                                             BufferedImage bi) {
        // create filter to change colors
        BandCombineOp bco =
                new BandCombineOp(colorMatrix, null);

        // create source and display Rasters
        Raster inputRaster = bi.getRaster();

        WritableRaster outputRaster =
                inputRaster.createCompatibleWritableRaster();

        // filter Rasters with changeColors filter
        bco.filter(inputRaster, outputRaster);


        // create new BufferedImage from display Raster
        return new BufferedImage(bi.getColorModel(),
                outputRaster, true, null);
    }

    public static ColorModel getRgbColorModel() {
        return ColorModel.getRGBdefault();
    }

    public static void fitScreen(Component c) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d
                = tk.getScreenSize();
        c.setSize(d.width, d.height);
    }

    public static Image getImage(Image img, final HppFilterInterface f) {
        RGBImageFilter rgbFilter = getRGBImageFilter(f);
        ImageProducer ip = img.getSource();
        ip = new FilteredImageSource(ip, rgbFilter);
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.createImage(ip);
    }

    private static RGBImageFilter getRGBImageFilter(final HppFilterInterface f) {
        return new RGBImageFilter() {
            public int filterRGB(int x, int y, int rgb) {
                Color c = new Color(rgb);
                int r = f.getR(c.getRed());
                int g = f.getG(c.getGreen());
                int b = f.getB(c.getBlue());
                return packInt(r, g, b);
            }
        };
    }

    public static Image getImage(int pels[], int w, int h) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.createImage(new MemoryImageSource(w,
                h,
                getRgbColorModel(),
                pels, 0,
                w));
    }

    public static Image getImage(short r[][], short g[][], short b[][]) {
        int w = r.length;
        int h = r[0].length;
        int pels[] = new int[w * h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++)
                pels[x + y * w]
                        = 0xFF000000
                        | ((0xFF & r[x][y]) << 16)
                        | ((0xFF & g[x][y]) << 8)
                        | (0xFF & b[x][y]);
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w,
                h,
                ColorModel.getRGBdefault(),
                pels, 0,
                w));
    }

    public static int[] getPels(Image image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        int pels[] = new int[w * h];

        try {
            new PixelGrabber(image, 0, 0,
                    w, h, pels, 0, w).grabPixels();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return pels;
    }

    public static int[] getPels(Image img, int width, int height) {
        int pels[] = new int[width * height];

        PixelGrabber grabber =
                new PixelGrabber(img, 0, 0,
                        width, height, pels, 0, width);

        try {
            grabber.grabPixels();
        } catch (InterruptedException e) {
        }
        return pels;
    }

    public static void pelsToShort(short r[][], short g[][], short b[][],
                                   int[] pels, int width, int height) {
        int i;
        ColorModel cm = getRgbColorModel();
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++) {
                i = x + y * width;
                b[x][y] = (short) cm.getBlue(pels[i]);
                g[x][y] = (short) cm.getGreen(pels[i]);
                r[x][y] = (short) cm.getRed(pels[i]);
            }
    }

    public static Image getGrayImage(short g[][]) {
        Toolkit tk =
                Toolkit.getDefaultToolkit();
        ColorModel cm = tk.getColorModel();
        int width = g.length;
        int height = g[0].length;
        int pels[] = new int[width * height];
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++) {
                pels[x + y * width] =
                        0xff000000
                        | (g[y][x] << 16)
                        | (g[y][x] << 8)
                        | g[y][x];
            }
        return tk.createImage(new
                MemoryImageSource(width,
                        height,
                        cm,
                        pels, 0,
                        width));
    }

    public static void writeHexImage(ImageBeanInterface ib) {
        WriterUtil.writeString(getHexImage(ib));
    }

    public static String getHexImage(ImageBeanInterface ib) {
        StringBuffer sb = new StringBuffer("");
        int width = ib.getImageWidth();
        int height = ib.getImageHeight();
        Image img = ib.getImage();

        int pixels[] = new int[width * height];
        PixelGrabber pg = new PixelGrabber(img,
                0,
                0,
                width,
                height,
                pixels,
                0,
                width);
        try {
            pg.grabPixels();
        } catch (InterruptedException e) {
        }
        String newline = new String("\n");
        int i = 0;
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                i = x + y * width;

                sb.append("0x" + Integer.toHexString(pixels[i]) + ", ");
            }
            sb.append(newline);
        }
        return sb.toString();
    }

    public static Image getImage(short g[][]) {
        if (g == null) return null;
        int width = g.length;
        int height = g[0].length;
        Toolkit tk =
                Toolkit.getDefaultToolkit();
        ColorModel cm = tk.getColorModel();
        int pels[] = new int[width * height];
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++) {
                pels[x + y * width] =
                        0xff000000
                        | (g[x][y] << 16)
                        | (g[x][y] << 8)
                        | g[x][y];
            }
        return tk.createImage(new
                MemoryImageSource(width,
                        height,
                        cm,
                        pels, 0,
                        width));
    }

    public static short[][] getGreenFromImage(Image img, ImageObserver io) {
        if (img == null) return null;
        int width = img.getWidth(io);
        int height = img.getHeight(io);
        int pels[] = new int[width * height];
        ColorModel cm = ColorModel.getRGBdefault();

        PixelGrabber grabber =
                new PixelGrabber(img, 0, 0,
                        width, height, pels, 0, width);

        try {
            grabber.grabPixels();
        } catch (InterruptedException e) {
        }
        ;
        short g[][] = new short[width][height];
        int i = 0;
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++) {
                i = x + y * width;
                g[x][y] = (short) cm.getGreen(pels[i]);
            }
        return g;
    }

    public static BufferedImage convolve(BufferedImage bi, float[][] blurMatrix) {
        // create ConvolveOp for blurring BufferedImage
        BufferedImageOp convolveOp =
                getConvolveOp(makeKernel(blurMatrix));
        // apply blurFilter to BufferedImage
        return convolveOp.filter(bi, null);
    }

    public static Image convolution(Image img, float k[][]) {
        return getImageBean(
                convolve(getBufferedImage(img),
                k)).getImage();

    }

    public static void print(Component c, String title) {
        java.awt.Toolkit tk = java.awt.Toolkit.getDefaultToolkit();
        java.awt.PrintJob pj =
                tk.getPrintJob(new Frame(),
                        title,
                        null);
        if (pj== null) return;
        c.paint(pj.getGraphics());
        pj.end();
    }

    public static void print(Component c) {
        print(c, null);
    }

    public static Image combineBands(float ar,
                                     float ag,
                                     float ab,
                                     Image img) {
        HppFilter3ImageProcessor h3ip =
                getLinearCombineBandsProcessor(ar, ag, ab);
        return h3ip.process(img);
    }

    public static HppFilter3ImageProcessor
            getLinearCombineBandsProcessor(float ar,
                                           float ag,
                                           float ab) {
        return new HppFilter3ImageProcessor(new GreyHppFilter3(ar, ag, ab));
    }


    public static Image sobel(Image img) {
        return convolution(img,
                Kernels.getSobel());
    }


    public static void clip(short a[][], short min, short max) {
        int w = a.length;
        int h = a[0].length;
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                if (a[x][y] < min) a[x][y] = min;
                if (a[x][y] > max) a[x][y] = max;
            }
    }

    /**
     * pasteBean alters is bigOne argument
     *
     * @param littleOne a smaller image pasted into
     * @param bigOne    a bigger image
     * @param x1        At this location
     * @param y1
     */
    public static void pasteBean(ShortImageBean littleOne,
                                 ShortImageBean bigOne,
                                 int x1, int y1) {
        int w = littleOne.getWidth();
        int h = littleOne.getHeight();
        int x2 = x1 + w;
        int y2 = y1 + h;
        int xd = 0;
        int yd = 0;
        short _r[][] = bigOne.getR();
        short _g[][] = bigOne.getG();
        short _b[][] = bigOne.getB();
        for (int x = x1; x < x2; x++)
            for (int y = y1; y < y2; y++) {
                _r[x][y] = littleOne.getR()[xd][yd];
                _g[x][y] = littleOne.getG()[xd][yd];
                _b[x][y] = littleOne.getB()[xd][yd];
                yd++;
            }
        yd = 0;
        xd++;
    }


    public static ShortImageBean
            cutBean(ShortImageBean sib,
                    int x1, int y1, int w, int h) {
        int xd = 0;
        int yd = 0;
        int x2 = x1 + w;
        int y2 = y1 + h;
        ShortImageBean cutBean = new ShortImageBean(w, h);
        short _r[][] = cutBean.getR();
        short _g[][] = cutBean.getG();
        short _b[][] = cutBean.getB();

        for (int x = x1; x < x2; x++)
            for (int y = y1; y < y2; y++) {
                _r[xd][yd] = sib.getR()[x][y];
                _g[xd][yd] = sib.getG()[x][y];
                _b[xd][yd] = sib.getB()[x][y];
                yd++;
            }
        yd = 0;
        xd++;
        return cutBean;
    }

    /**
     * Compute the average image between img1 and img2.
     *
     * @param img1
     * @param img2
     * @return average image
     */
    public static Image average(Image img1, Image img2) {
        ShortImageBean sib1 = new ShortImageBean(img1);
        ShortImageBean sib2 = new ShortImageBean(img2);
        sib1.average(sib2);
        return sib1.getImage();
    }

    /**
     * Computer the average image from the image array, ia.
     *
     * @param ia
     * @return average image.
     */
    public static Image average(Image ia[]) {
        ShortImageBean sib1 = new ShortImageBean(ia[0]);
        for (int i = 1; i < ia.length; i++) {
            ShortImageBean sib2 = new ShortImageBean(ia[i]);
            sib1.average(sib2);
        }
        return sib1.getImage();
    }

    public static Image getImageResource(Window w, String iconFileName) {
        return w.getToolkit().getImage(w.getClass().getResource("images/" + iconFileName));
    }

    public static Image getImageResource(Object o, String iconFileName) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.getImage(o.getClass().getResource("images/" + iconFileName));
    }

    /**
     * Helper function to load an icon image from the JAR file of which
     * this class is a part.
     */
    public static ImageIcon fetchIcon(Window w,
                                      String iconFileName) {
        return new ImageIcon(getImageResource(w, iconFileName));
    }

    public static void main(String args[]) {
        testListProperties();
    }

    private static void testListProperties() {
        final Toolkit tk = Toolkit.getDefaultToolkit();

        final String propertyName = //"win.propNames";
        "";
        String propnames[] = (String[]) tk
                .getDesktopProperty(propertyName);
        System.out.println("Supported windows property names:");
        for (int i = 0; i < propnames.length; i++) {
            System.out.println(propnames[i]);
        }

    }
    public static void saveAsJpeg(BufferedImage buf, File f){
        try{
           JPEGCodec.createJPEGEncoder(new FileOutputStream(f)).encode(buf);
        }catch(java.io.IOException e){
            e.printStackTrace();
        }
    }
    public static void saveAsGif(Image img, File f) {
        try {
            ip.vs.WriteGIF.DoIt(img, f + "");
        } catch (IOException e) {
            e.printStackTrace();
        } catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public static Image gaussian(int kernelWidth, double sigma, Image img) {

        ImageProcessorInterface ipi =
                new GaussianSmoothingProcessor(kernelWidth, sigma);
        return ipi.process(img);
    }

    public static Image negate(Image img) {
        ImageProcessorInterface ipi = InvertFilter.getProcessor();
        return ipi.process(img);
    }

    public static Image threshold(Image img, double b) {
        Threshold3Processor t3p = new Threshold3Processor(b);
        return t3p.process(img);
    }
    public static Image enahe(double alpha, Image img){
                EnaheFilter e = new EnaheFilter(img, alpha / 10.0);
        return new HppFilterImageProcessor(e).process(img);
    }
    public static Image unahe(Image img) {
        EqualizationFilter cf = new EqualizationFilter(img);
        HppFilterImageProcessor hip = new HppFilterImageProcessor(cf);
        return hip.process(img);
    }

    public static Image smooth(int kernelWidth, double sigma, Image image) {
        GaussianSmoothingProcessor gsp =
                new GaussianSmoothingProcessor(kernelWidth, sigma);
        return gsp.process(image);
    }

    public static Image colorize(double ar, double ag, double ab, Image img) {
        PseudoColorFilter pcf = new PseudoColorFilter(ar, ag, ab);
        HppFilterImageProcessor hip = new HppFilterImageProcessor(pcf);
        return hip.process(img);
    }

    public static Image getContrastBrightnessAdjustedImage(double c, double b, Image img) {
        ContrastFilter cf = new ContrastFilter(c, b);
        HppFilterImageProcessor hpp = new HppFilterImageProcessor(cf);
        return hpp.process((img));
    }

    // - - Here is the BLogic.....
    public static Image getImage(File f)  {
        if (!f.canRead()){
            f = Futil.getReadFile("f cannot read, where is it?");
        }
        try {
            FileInputStream fis =
                    new FileInputStream(f);
            int type = getType(fis);
            if (type == StreamSniffer.GIF87a)
                return getGifJpgPngImage(f);
            if (type == StreamSniffer.GIF89a)
                return getGifJpgPngImage(f);
            if (type == StreamSniffer.JPEG)
                return getGifJpgPngImage(f);
            if (type == StreamSniffer.JPG)
                return getGifJpgPngImage(f);
            if (type == StreamSniffer.PNG_IMAGE)
                return getGifJpgPngImage(f);
            if (type == StreamSniffer.PPM)
                return getPpmImage(f);
            if (type == StreamSniffer.PPM_RAWBITS)
                return getPpmImage(f);
            else In.message("type not recognized; getImage returns null");
            Futil.close(fis);
        } catch (FileNotFoundException e) {
            In.message(e);

        }
        return null;
    }

    public static int getType(FileInputStream fis) {
        StreamSniffer ss =
                new StreamSniffer(fis);
        return ss.classifyStream();
    }

    public static void testSniff() {
        FileInputStream fis =
                Futil.getFileInputStream("select a new data file");
        StreamSniffer ss =
                new StreamSniffer(fis);

        System.out.println("fee fi fo fum I smell:" + ss);
        Futil.close(fis);
    }

    public static void saveAsGif(Image img, String fn) {
        try {
            ip.vs.WriteGIF.DoIt(img,
                    fn);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * Captures the entire screen
     * @return SreenImage
     * @throws AWTException
     */
    public static BufferedImage captureWholeScreen() throws AWTException {
        return new Robot().createScreenCapture(
                getFullScreen());
    }

    public static BufferedImage captureScreen(Component c)
            throws AWTException {
        return new Robot().createScreenCapture(new Rectangle(c.getX(), c.getY(),
                c.getWidth(), c.getHeight()));
    }
    public static Rectangle getFullScreen(){
        return new Rectangle(new Point(0,0),getScreenSize());
    }
    public static Dimension getScreenSize() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.getScreenSize();
    }
    /**
     * Fast scaling of a buffered image by using replicated pixels.
     * Used the Image.scale method with a Image.SCALE_FAST for
     * fastest possible result.
     * If either the <code>width</code>
     * or <code>height</code> is a negative number then a value is
     * substituted to maintain the aspect ratio of the original image
     * dimensions.
     * @param bi
     * @param width
     * @param height
     * @return
     */
    public static BufferedImage scaleFast(BufferedImage bi, int width, int height){
        Image img = getImage(bi);
        img = scaleFast(img,width,height);
        return ImageUtils.getBufferedImage(img);
    }
    /**
     * Uses
     * the Image.scale method with a Image.SCALE_SMOOTH for a better result
     * than SCALE_FAST. If either the <code>width</code> or <code>height</code> is a
     * negative number then a value is substituted to maintain the aspect
     * ratio of the original image dimensions.
     *
     * @param bi
     * @param width
     * @param height
     * @return
     */
    public static BufferedImage scaleSmooth(BufferedImage bi,
                                          int width,
                                          int height) {
        Image img = getImage(bi);
        img = scaleSmooth(img, width, height);
        return ImageUtils.getBufferedImage(img);
    }
    /**
     * Uses the Image.SCALE_FAST rendering hint to make use of replicated
     * pixels for creating the new image. No averaging here...
     * If either the <code>width</code>
     * or <code>height</code> is a negative number then a value is
     * substituted to maintain the aspect ratio of the original image
     * dimensions.
     * @param img
     * @param width
     * @param height
     * @return
     */
    public static Image scaleFast(Image img,int width,int height){
        return img.getScaledInstance(width,height,Image.SCALE_FAST);
    }

    /**
     * Uses the Image.SCALE_SMOOTH rendering hint to make use of
     * averaging. If either
     * the <code>width</code> or <code>height</code> is a negative number
     * then a value is substituted to maintain the aspect ratio of the
     * original image dimensions.
     *
     * @param img
     * @param width
     * @param height
     * @return
     */
    public static Image scaleSmooth(Image img, int width, int height) {
        return img.getScaledInstance(width, height, Image.SCALE_SMOOTH);
    }
    public static String getImageIoFormat() {
        return (String) In.multiPrompt(
                getImageIOFormatNames(),
                "select an output format", "format selector dialog");
    }

    public static String[] getImageIOFormatNames() {
        final String[] writerFormatNames =
                ImageIO.getWriterFormatNames();
        return writerFormatNames;
    }
    /**
     * The following code does not seem to work on a mac.
     * I dont know why.
     * @param bi
     * @param f
     * @throws IOException
     */
   public static void saveAsTiff(BufferedImage bi, File f)
           throws IOException {
       OutputStream os = new FileOutputStream(f);
       TIFFEncodeParam tep = new TIFFEncodeParam();
       ImageEncoder encoder= ImageCodec.createImageEncoder("TIFF",os,tep);
       encoder.encode(bi);
       os.close();
   }

    /**
     * grab a screen capture in png format.
     *
     * @param rect
     * @throws java.awt.AWTException
     * @throws java.io.IOException
     */
    public static byte[] grabAPngImage(Rectangle rect)
            throws AWTException, IOException {
        // create screen shot
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(rect);
        // save captured image to PNG file
        ImageIO.write(image, "png", baos);
        baos.close();
        return baos.toByteArray();
    }

    public static BufferedImage getBufferedImage(String s) {
        return getBufferedImage(
                getImage(ResourceManager.getImageFile(s)));
    }


    private static class imagePanel extends JPanel {
        private final Image img;

        public imagePanel(Image img) {
            this.img = img;
            setLayout(new FlowLayout());
        }

        public void paint(Graphics g) {
            Dimension d = getSize();
            g.drawImage(img, 0, 0, d.width, d.height, this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(img.getWidth(this),
                    img.getHeight(this));
        }
    }

    public static void saveAsPPM(Image img, String fn) {
        ShortImageBean sib = new ShortImageBean(img);
        WritePPM.doIt(sib.getR(),
                sib.getG(),
                sib.getB(),
                fn);
    }

}
