// ImagePanel.java
// ImagePanel contains an image for display.  The image is
// converted to a BufferedImage for filtering purposes.
package j2d;

// Java core packages

import javax.swing.*;
import java.util.Vector;
import java.awt.*;

public class ImagePanels
        extends JPanel {

    private Vector imagePanelVector = new Vector();

    public void add(ImagePanel ip ){
        imagePanelVector.addElement(ip);
        setLayout(new GridLayout(0,1));
        super.add(ip);
    }
    public ImagePanel[] getImagePanels() {
        ImagePanel ipa[] = new ImagePanel[imagePanelVector.size()];
        imagePanelVector.copyInto(ipa);
        return ipa;
    }
    public ImagePanels() {
    }

    public void update(ImageProcessorInterface ip) {
        ImagePanel ipa[] = getImagePanels();
        for (int i=0; i < ipa.length; i++)
            ipa[i].update(ip);
        repaint();
    }

    public void revert() {
        ImagePanel ipa[] = getImagePanels();
        for (int i = 0; i < ipa.length; i++)
            ipa[i].revert();
        repaint();
    }

}


