/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 19, 2003
 * Time: 11:13:42 AM
 */
package j2d;

import javax.swing.*;
import java.awt.*;

public class ComparisonUtils {
    public static void showComparisonFrame(JPanel jp) {
        JFrame jf = new JFrame();
        Container c = jf.getContentPane();

        c.setLayout(new BorderLayout());

        c.add(jp, BorderLayout.CENTER);

        jf.setDefaultCloseOperation(
                WindowConstants.DISPOSE_ON_CLOSE);
        jf.pack();
        jf.setSize(400, 400);
        jf.setVisible(true);

    }

    public static JPanel getComparisonPanel(Image sourceImage,
                                            ImageProcessorFactory ipf) {
        ShortImageBeans sibs =
                ShortImageBeans.computeComparisons(sourceImage, ipf, 9);
        //showOrientationSubBands(sibs);
        ShortImageBean max = sibs.getMaxBean();
        ShortImageBean oMax = max.getImageFlowBean();
        sibs.add(max);
        sibs.add(oMax);
        //showComparisonFrame(getComparisonPanel(
        //        sib.getOrientationSubBands(),0,4));
        return getComparisonPanel(sibs, 0, 3);
    }

    public static void showOrientationSubBands(ShortImageBeans sib) {

        ShortImageBeans osb = sib.getOrientationSubBands();
        showComparisonFrame(getComparisonPanel(osb, 0, 3));
    }

    public static void showMaxFlowFrame(ShortImageBeans sib) {
        ShortImageBean max = sib.getMaxBean();
        ShortImageBeans maxFlow = new ShortImageBeans();
        maxFlow.add(max);
        maxFlow.add(max.getImageFlowBean());
        showComparisonFrame(getComparisonPanel(maxFlow, 1, 0));
    }

    public static JPanel getComparisonPanel(ShortImageBeans sibs, int r, int c) {
        JPanel jp = getComparisonPanel(r, c);
        ShortImageBean sib[] = sibs.getShortImageBeans();
        for (int i = 0; i < sib.length; i++)
            jp.add(new ImageProcessButton(sib[i].getImage()));
        return jp;
    }


    public static JPanel getComparisonPanel2(Image sourceImage,
                                             ImageProcessorFactory ipf) {
        JPanel jp = getComparisonPanel(0, 3);

        ImageProcessButton ipa[] = new ImageProcessButton[9];

        ipa[0] = new ImageProcessButton(sourceImage);
        jp.add(ipa[0]);
        for (int i = 1; i < 9; i++) {
            ipa[i] = new ImageProcessButton(sourceImage);
            ipa[i].update(ipf.getProcessor(i));
            jp.add(ipa[i]);
        }
        return jp;
    }

    public static JPanel getComparisonPanel(int r, int c) {
        JPanel jp = new JPanel();
        gui.layouts.PreferredSizeGridLayout
                lo = new gui.layouts.PreferredSizeGridLayout(
                        r, c, 0, 0);
        lo.setBoundableInterface(new
                gui.layouts.AspectBoundable());
        jp.setMinimumSize(new Dimension(100, 100));

        jp.setLayout(lo);
        return jp;
    }
}
