package ip.transforms;

import math.Mat2;

/**
 * User: lyon
 * Date: Dec 22, 2002
 * Time: 1:53:40 AM
 */
public class Gauss {

    public static final double gauss(
            double x, double y,
            double xc, double yc, double sigma) {
        double dx = x - xc;
        double dy = y - yc;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double sigma2 = sigma * sigma;
        double oneOnSigma2 = 1 / sigma2;
        return
                Math.exp(-(dx2 + dy2) *
                oneOnSigma2 / 2) / Math.PI * oneOnSigma2 / 2;
    }

    public static final double gauss(
            double x,
            double xc, double sigma) {
        double oneOnSigmaSquaredOn2 = 1 / (sigma * sigma) / 2;
        return
                Math.exp(-((x - xc) * (x - xc)) *
                oneOnSigmaSquaredOn2) / Math.PI * oneOnSigmaSquaredOn2;
    }

    public static void printGaussKernel(
            int M, int N,
            double sigma, double centerMax) {
        short k[][] = new short[M][N];
        int xc = M / 2;
        int yc = N / 2;
        double scale = centerMax * 2 * Math.PI * sigma * sigma;
        for (int x = 0; x < k.length; x++)
            for (int y = 0; y < k[0].length; y++)
                k[x][y] = (short)
                        (scale * gauss(x, y, xc, yc, sigma));
        //Mat.printKernel(k,"gauss"+k.length);
    }

    public static void printGaussKernel(
            int M, int N,
            double sigma) {
        float k[][] = getGaussKernel(M, N, sigma);
        Mat2.printKernel(k, "gauss" + k.length);
    }

    public static float[][] getGaussKernel(
            int M, int N,
            double sigma) {
        float k[][] = new float[M][N];
        int xc = M / 2;
        int yc = N / 2;
        for (int x = 0; x < k.length; x++)
            for (int y = 0; y < k[0].length; y++)
                k[x][y] = (float) gauss(x, y, xc, yc, sigma);
        Mat2.normalize(k);
        return k;
    }

    public static double getMagnitudeOfTheDerivativeOfGauss(
            double x, double y,
            double xc, double yc, double sigma) {
        ConvolutionUtils.t2 = Math.pow(2.0 * x - 2.0 * xc, 2.0);
        ConvolutionUtils.t3 = sigma * sigma;
        ConvolutionUtils.t4 = ConvolutionUtils.t3 * ConvolutionUtils.t3;
        ConvolutionUtils.t5 = ConvolutionUtils.t4 * ConvolutionUtils.t4;
        ConvolutionUtils.t6 = 1 / ConvolutionUtils.t5;
        ConvolutionUtils.t9 = Math.pow(x - xc, 2.0);
        ConvolutionUtils.t11 = Math.pow(y - yc, 2.0);
        ConvolutionUtils.t16 = Math.pow(Math.exp(-(ConvolutionUtils.t9 + ConvolutionUtils.t11) / ConvolutionUtils.t3 / 2), 2.0);
        ConvolutionUtils.t17 = Math.PI * Math.PI;
        ConvolutionUtils.t19 = ConvolutionUtils.t16 / ConvolutionUtils.t17;
        ConvolutionUtils.t22 = Math.pow(2.0 * y - 2.0 * yc, 2.0);
        double ddx = ConvolutionUtils.t2 * ConvolutionUtils.t6 * ConvolutionUtils.t19;
        double ddy = ConvolutionUtils.t22 * ConvolutionUtils.t6 * ConvolutionUtils.t19;
        ConvolutionUtils.t26 = Math.sqrt(ddx + ddy);
        ConvolutionUtils.t27 = ConvolutionUtils.t26 / 4;
        return ConvolutionUtils.t27;
    }

    public static void printMagnitudeOfTheDerivativeOfGauss(
            int M, int N,
            double sigma) {
        float k[][] = getMagnitudeOfTheDerivativeOfGauss(M, N, sigma);
        //Mat.printKernel(k,"MagnitudeOfTheDerivativeOfGauss"+k.length);
    }

    public static float[][] getMagnitudeOfTheDerivativeOfGauss(
            int M, int N,
            double sigma) {
        float k[][] = new float[M][N];
        int xc = M / 2;
        int yc = N / 2;
        for (int x = 0; x < k.length; x++)
            for (int y = 0; y < k[0].length; y++)
                k[x][y] = (float)
                        getMagnitudeOfTheDerivativeOfGauss(x, y, xc, yc, sigma);
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getGauss3() {
        float k[][] = {
            {1, 2, 1},
            {2, 4, 2},
            {1, 2, 1}
        };
        Mat2.scale(k, 1 / 16.0);
        return k;
    }

    public static float[][] getGauss7() {
        float k [][] = {

            {1, 1, 2, 2, 2, 1, 1},
            {1, 2, 2, 4, 2, 2, 1},
            {2, 2, 4, 8, 4, 2, 2},
            {2, 4, 8, 16, 8, 4, 2},
            {2, 2, 4, 8, 4, 2, 2},
            {1, 2, 2, 4, 2, 2, 1},
            {1, 1, 2, 2, 2, 1, 1}
        };
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getGauss15() {
        float k[][] = {
            {1.9045144E-7f, 9.671922E-7f, 3.8253193E-6f, 1.1782813E-5f, 2.8265502E-5f, 5.2806907E-5f, 7.6833596E-5f, 8.7063876E-5f, 7.6833596E-5f, 5.2806907E-5f, 2.8265502E-5f, 1.1782813E-5f, 3.8253193E-6f, 9.671922E-7f, 1.9045144E-7f},
            {9.671922E-7f, 4.9118075E-6f, 1.9426576E-5f, 5.9838065E-5f, 1.4354405E-4f, 2.681756E-4f, 3.901932E-4f, 4.4214682E-4f, 3.901932E-4f, 2.681756E-4f, 1.4354405E-4f, 5.9838065E-5f, 1.9426576E-5f, 4.9118075E-6f, 9.671922E-7f},
            {3.8253193E-6f, 1.9426576E-5f, 7.6833596E-5f, 2.3666414E-4f, 5.677278E-4f, 0.0010606551f, 0.001543244f, 0.0017487246f, 0.001543244f, 0.0010606551f, 5.677278E-4f, 2.3666414E-4f, 7.6833596E-5f, 1.9426576E-5f, 3.8253193E-6f},
            {1.1782813E-5f, 5.9838065E-5f, 2.3666414E-4f, 7.2897685E-4f, 0.0017487246f, 0.0032670477f, 0.0047535263f, 0.0053864513f, 0.0047535263f, 0.0032670477f, 0.0017487246f, 7.2897685E-4f, 2.3666414E-4f, 5.9838065E-5f, 1.1782813E-5f},
            {2.8265502E-5f, 1.4354405E-4f, 5.677278E-4f, 0.0017487246f, 0.004194972f, 0.00783724f, 0.011403117f, 0.012921424f, 0.011403117f, 0.00783724f, 0.004194972f, 0.0017487246f, 5.677278E-4f, 1.4354405E-4f, 2.8265502E-5f},
            {5.2806907E-5f, 2.681756E-4f, 0.0010606551f, 0.0032670477f, 0.00783724f, 0.014641892f, 0.021303825f, 0.024140399f, 0.021303825f, 0.014641892f, 0.00783724f, 0.0032670477f, 0.0010606551f, 2.681756E-4f, 5.2806907E-5f},
            {7.6833596E-5f, 3.901932E-4f, 0.001543244f, 0.0047535263f, 0.011403117f, 0.021303825f, 0.030996885f, 0.03512407f, 0.030996885f, 0.021303825f, 0.011403117f, 0.0047535263f, 0.001543244f, 3.901932E-4f, 7.6833596E-5f},
            {8.7063876E-5f, 4.4214682E-4f, 0.0017487246f, 0.0053864513f, 0.012921424f, 0.024140399f, 0.03512407f, 0.039800785f, 0.03512407f, 0.024140399f, 0.012921424f, 0.0053864513f, 0.0017487246f, 4.4214682E-4f, 8.7063876E-5f},
            {7.6833596E-5f, 3.901932E-4f, 0.001543244f, 0.0047535263f, 0.011403117f, 0.021303825f, 0.030996885f, 0.03512407f, 0.030996885f, 0.021303825f, 0.011403117f, 0.0047535263f, 0.001543244f, 3.901932E-4f, 7.6833596E-5f},
            {5.2806907E-5f, 2.681756E-4f, 0.0010606551f, 0.0032670477f, 0.00783724f, 0.014641892f, 0.021303825f, 0.024140399f, 0.021303825f, 0.014641892f, 0.00783724f, 0.0032670477f, 0.0010606551f, 2.681756E-4f, 5.2806907E-5f},
            {2.8265502E-5f, 1.4354405E-4f, 5.677278E-4f, 0.0017487246f, 0.004194972f, 0.00783724f, 0.011403117f, 0.012921424f, 0.011403117f, 0.00783724f, 0.004194972f, 0.0017487246f, 5.677278E-4f, 1.4354405E-4f, 2.8265502E-5f},
            {1.1782813E-5f, 5.9838065E-5f, 2.3666414E-4f, 7.2897685E-4f, 0.0017487246f, 0.0032670477f, 0.0047535263f, 0.0053864513f, 0.0047535263f, 0.0032670477f, 0.0017487246f, 7.2897685E-4f, 2.3666414E-4f, 5.9838065E-5f, 1.1782813E-5f},
            {3.8253193E-6f, 1.9426576E-5f, 7.6833596E-5f, 2.3666414E-4f, 5.677278E-4f, 0.0010606551f, 0.001543244f, 0.0017487246f, 0.001543244f, 0.0010606551f, 5.677278E-4f, 2.3666414E-4f, 7.6833596E-5f, 1.9426576E-5f, 3.8253193E-6f},
            {9.671922E-7f, 4.9118075E-6f, 1.9426576E-5f, 5.9838065E-5f, 1.4354405E-4f, 2.681756E-4f, 3.901932E-4f, 4.4214682E-4f, 3.901932E-4f, 2.681756E-4f, 1.4354405E-4f, 5.9838065E-5f, 1.9426576E-5f, 4.9118075E-6f, 9.671922E-7f},
            {1.9045144E-7f, 9.671922E-7f, 3.8253193E-6f, 1.1782813E-5f, 2.8265502E-5f, 5.2806907E-5f, 7.6833596E-5f, 8.7063876E-5f, 7.6833596E-5f, 5.2806907E-5f, 2.8265502E-5f, 1.1782813E-5f, 3.8253193E-6f, 9.671922E-7f, 1.9045144E-7f}};
//sum=0.9999999983459134
        return k;
    }
}
