package ip.hak;

import gui.ClosableJFrame;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.ZipInputStream;

public class RecieveFrame extends ClosableJFrame
        implements ActionListener {
    short r[][];
    short g[][];
    short b[][];
    int w, h;
    MenuBar mb = new MenuBar();
    Menu fMenu = new Menu("File");
    MenuItem open_MI, quit_MI;
    Image img = null;
    Button ntButton, ldButton;

    public RecieveFrame(String title, int wi, int he) {
        super(title);
        w = wi;
        h = he;
        init();
        setLocation(400, 0);
        setVisible(true);
    }

    public void initArrays() {
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                r[x][y] = 0;
                g[x][y] = 0;
                b[x][y] = 0;
            }
    }

    public void init() {
        setContainerLayout(null);
        int c = 203;
        Color mc = new Color(c, c, c);
        setBackground(mc);
        setSize(380, 320);
        open_MI = new MenuItem("Open Image Zip File..");
        fMenu.add(open_MI);
        open_MI.addActionListener(this);
        quit_MI = new MenuItem("Quit");
        fMenu.add(quit_MI);
        quit_MI.addActionListener(this);
        mb.add(fMenu);
        setMenuBar(mb);

        ldButton = new Button("Load");
        ldButton.setSize(50, 20);
        ldButton.setLocation(300, 100);
        addComponent(ldButton);
        ldButton.setEnabled(true);
        ldButton.addActionListener(this);

        ntButton = new Button("Next");
        ntButton.setSize(50, 20);
        ntButton.setLocation(300, 140);
        addComponent(ntButton);
        ntButton.setEnabled(false);
        ntButton.addActionListener(this);

        r = new short[w][h];
        g = new short[w][h];
        b = new short[w][h];
        initArrays();

    }

    public void sendData(short sr[][],
                         short sg[][],
                         short sb[][],
                         int ei) {
        for (int y = 0; y < ei; y++)
            for (int x = 0; x < w; x++) {
                r[x][y] = sr[x][y];
                g[x][y] = sg[x][y];
                b[x][y] = sb[x][y];
            }
        ip.transforms.Lifting.backwardHaar(r);
        ip.transforms.Lifting.backwardHaar(g);
        ip.transforms.Lifting.backwardHaar(b);

        img = short2Image(w, h);
        repaint();
    }

    public Image short2Image(int wi, int he) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ColorModel cm = ColorModel.getRGBdefault();

        int pels[] = new int[wi * he];
        for (int x = 0; x < wi; x++)
            for (int y = 0; y < he; y++) {
                pels[x + y * wi] = 0xff000000 |
                        (r[x][y] << 16)
                        |
                        (g[x][y] << 8)
                        | b[x][y];
            }
        Image i = tk.createImage(
                new MemoryImageSource(wi, he, cm, pels, 0, wi));
        return i;
    }

    public void paint(Graphics g) {
        Rectangle rec = getBounds();
        if (img == null) {
            g.drawRect(20, rec.height - 276, 256, 256);
            return;
        }

        g.drawImage(img, 20, rec.height - 276, 256, 256, this);

    }

    public void open() {
        FileDialog fd = new FileDialog(this,
                "Select LZC file",
                FileDialog.LOAD);
        fd.setFile("*.lzc");
        fd.setVisible(true);

        String fn = fd.getFile();
        if (fn == null)
            return;
        String dir = fd.getDirectory();

        open(dir + fn);
    }

    public void open(String fn) {
        try {
            FileInputStream fis = new FileInputStream(fn);
            open(fis);
            ntButton.setEnabled(true);
        } catch (IOException e) {
            System.out.println(e);
        }
    }

    ObjectInputStream ois;
    ZipInputStream zis;

    public void open(FileInputStream fis) {
        zis = new ZipInputStream(fis);
        initArrays();

        readNext(zis);
    }

    int sind = 0;
    int eind;

    public void readNext(ZipInputStream zis) {
        short rt[][], gt[][], bt[][];

        try {
            zis.getNextEntry();
            ois = new ObjectInputStream(zis);
            try {
                rt = (short[][]) ois.readObject();
                gt = (short[][]) ois.readObject();
                bt = (short[][]) ois.readObject();
                int size = rt[0].length;
                eind = sind + size;
                if (eind >= h) {
                    ntButton.setEnabled(false);
                    ntButton.transferFocus();
                }
                ip.transforms.Lifting.forwardHaar(r);
                ip.transforms.Lifting.forwardHaar(g);
                ip.transforms.Lifting.forwardHaar(b);
                for (int y = sind, si = 0; y < eind; y++, si++)
                    for (int x = 0; x < w; x++) {
                        r[x][y] = rt[x][si];
                        g[x][y] = gt[x][si];
                        b[x][y] = bt[x][si];
                    }
                sind = eind;
                ip.transforms.Lifting.backwardHaar(r);
                ip.transforms.Lifting.backwardHaar(g);
                ip.transforms.Lifting.backwardHaar(b);
                img = short2Image(w, h);
                repaint();
            } catch (ClassNotFoundException e) {
                System.out.println(e);
            }
        } catch (IOException e) {
            System.out.println(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == open_MI) {
            open();
            return;
        }

        if (e.getSource() == ldButton) {
            open();
            return;
        }

        if (e.getSource() == quit_MI) {

            dispose();
            return;
        }

        if (e.getSource() == ntButton) {
            readNext(zis);
            return;
        }
    }

}