package ip.hak;

import java.awt.*;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;


public class P4 extends Component {
    Point center;
    Image image, selectedImage, unselectedImage;
    Dimension imageDim;
    boolean inv;
    int idx, idy;

    public P4(Point cen, int ix, int iy) {
        center = cen;
        unselectedImage = byte2Image(unselected);
        selectedImage = byte2Image(selected);
        image = unselectedImage;
        imageDim = new Dimension(unselected.length, unselected[0].length);
        inv = false;
        idx = ix;
        idy = iy;
    }

    public int getIdx() {
        return idx;
    }

    public int getIdy() {
        return idy;
    }

    public void setCenter(Point p) {
        center = p;
    }

    public boolean contains(Point p) {
        int hx = imageDim.width / 2;
        int hy = imageDim.height / 2;
        int minx = center.x - hx;
        int maxx = center.x + hx;
        int miny = center.y - hy;
        int maxy = center.y + hy;

        return (p.x >= minx && p.x <= maxx && p.y >= miny && p.y <= maxy && image != null);
    }

    public Point getCenter() {
        return center;
    }

    public Dimension getPreferredSize() {
        return imageDim;
    }

    public void paint(Graphics g) {
        if (image != null) {
            Dimension d = imageDim;
            g.drawImage(image, 0, 0, d.width, d.height, this);
        }
    }

    private static Image byte2Image(byte r[][]) {
        int w = r.length;
        int h = r[0].length;
        int v = 0;
        Toolkit tk = Toolkit.getDefaultToolkit();
        int pels[] = new int[w * h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                if (r[x][y] == 1)
                    v = 255;
                else
                    v = 0;
                pels[y + x * h] = 0xff000000 | (v << 16) | (v << 8) | v;
            }
        Image i = tk.createImage(new MemoryImageSource(w, h, ColorModel.getRGBdefault(), pels, 0, w));
        return i;
    }

    public void invert() {
        if (!inv)
            image = selectedImage;
        else
            image = unselectedImage;
        inv = !inv;
        repaint();
    }

    private static byte selected[][] = {
        {1, 1, 1, 0, 0, 0, 0, 1, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 0, 0, 0, 0, 0, 0, 0, 0, 1},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {1, 0, 0, 0, 0, 0, 0, 0, 0, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 1, 1, 0, 0, 1, 1, 1, 1}};


    private static byte unselected[][] = {
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
        {1, 1, 1, 0, 0, 0, 0, 1, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 1, 0, 0, 0, 0, 1, 1, 1},
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
}