package ip.hak;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MessageDialog extends ClosableDialog implements ActionListener {
    Label messageLabel;
    Button okButton;


    public MessageDialog(Frame f, String name, boolean md, String message, int w, int h) {
        super(f, name, md);
        setLayout(new GridLayout(2, 1, 15, 15));

        messageLabel = new Label(message);
        messageLabel.setAlignment(messageLabel.CENTER);
        add(messageLabel);

        okButton = new Button("OK");
        add(okButton);
        okButton.addActionListener(this);

        setSize(w, h);
        show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == okButton) {
            dispose();
            return;
        }
    }
}
