package ip.gui.frames;

import gui.ClosableJFrame;
import gui.icons.Icons;
import ip.graphics.Globals;
import ip.gui.IconComponent;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class IconFrame
        extends ClosableJFrame implements ActionListener {

    private Panel iconPanel = new Panel(new FlowLayout());


    private IconComponent polygonIcon =
            getIconComponent(Icons.polygon);
    private IconComponent eraserIcon =
            getIconComponent(Icons.eraser);
    private IconComponent pencilIcon =
            getIconComponent(Icons.pencil);
    private IconComponent brushIcon =
            getIconComponent(Icons.brush);
    private IconComponent handIcon =
            getIconComponent(Icons.hand);
    private IconComponent magnifyingGlassIcon =
            getIconComponent(Icons.magnifyingGlass);
    private IconComponent marqeeIcon =
            getIconComponent(Icons.marqee);
    private IconComponent paintCanIcon =
            getIconComponent(Icons.paintCan);
    private IconComponent eyeDropperIcon =
            getIconComponent(Icons.eyeDropper);
    private IconComponent xImageIcon =
            getIconComponent(Icons.xImage);
    private IconComponent ovalIcon =
            getIconComponent(Icons.oval);
    private IconComponent arcIcon =
            getIconComponent(Icons.arc);
    private IconComponent arrowIcon =
            getIconComponent(Icons.arrow);
    private IconComponent circleIcon =
            getIconComponent(Icons.circle);

    //IconComponent warpIcon =
    //		getIconComponent(warp);


    private Vector iconList = new Vector();

    private void addIcons() {
        addIcon(getEraserIcon(), getIconPanel());
        addIcon(getPencilIcon(), getIconPanel());
        addIcon(getBrushIcon(), getIconPanel());
        addIcon(getMagnifyingGlassIcon(), getIconPanel());
        addIcon(getEyeDropperIcon(), getIconPanel());
        addIcon(getXImageIcon(), getIconPanel());
        //addIcon(warpIcon,iconPanel);



        //addIcon(polygonIcon,iconPanel);
        //addIcon(circleIcon,iconPanel);
        //addIcon(arrowIcon,iconPanel);
        //addIcon(arcIcon,iconPanel);
        //addIcon(ovalIcon,iconPanel);
        //addIcon(paintCanIcon,iconPanel);
        addIcon(getMarqeeIcon(), getIconPanel());
        addIcon(getHandIcon(), getIconPanel());
        addComponent(getIconPanel());
    }

    public IconComponent getIconComponent(byte icon[][]) {
        IconComponent ic = new IconComponent(icon);
        return ic;
    }

    public void addIcon(IconComponent ic, Container c) {
        ic.addActionListener(this);
        c.add(ic);
        getIconList().addElement(ic);
    }

    public void deselectOtherIcons(IconComponent selectedIcon) {
        for (int i = 0; i < getIconList().size(); i++) {
            IconComponent ic = (IconComponent) getIconList().elementAt(i);
            ic.invert(ic.equals(selectedIcon));
        }
    }

    private Label width = new Label("W:0   ");
    private Label height = new Label("H:0   ");
    private Label red = new Label("R:0   ");
    private Label green = new Label("G:0   ");
    private Label blue = new Label("B:0   ");
    private Label xPosition = new Label("x:0   ");
    private Label yPosition = new Label("y:0   ");

    private void addInfo() {
        Panel p = new Panel(new GridLayout(1, 2));
        p.add(width);
        p.add(height);
        p.add(red);
        p.add(green);
        p.add(blue);
        p.add(getXPosition());
        p.add(getYPosition());

        addComponent(p, BorderLayout.CENTER);

    }

    public IconFrame() {
        super(Globals.title);
        setContainerLayout(new GridLayout(0, 1));
        addIcons();
        addInfo();
        pack();
    }

    public void setLabels(int w, int h, int r, int g, int b) {
        width.setText("W:" + w);
        height.setText("H:" + h);
        red.setText("R:" + r);
        green.setText("G:" + g);
        blue.setText("B:" + b);
        repaint();
    }

    public void setPosition(int x, int y) {
        getXPosition().setText("x:" + x);
        getYPosition().setText("y:" + y);
    }


    public static void main(String args[]) {
        System.out.println("Icon concepts!");
        IconFrame iconFrame = new IconFrame();
        iconFrame.setVisible(true);
    }

    private IconComponent selectedIcon;

    public IconComponent getSelectedIcon() {
        return selectedIcon;
    }

    public void actionPerformed(ActionEvent e) {
        //System.out.println(e);

        setSelectedIcon((IconComponent) e.getSource());
        deselectOtherIcons(getSelectedIcon());
    }

    public Panel getIconPanel() {
        return iconPanel;
    }

    public void setIconPanel(Panel iconPanel) {
        this.iconPanel = iconPanel;
    }

    public IconComponent getPolygonIcon() {
        return polygonIcon;
    }

    public void setPolygonIcon(IconComponent polygonIcon) {
        this.polygonIcon = polygonIcon;
    }

    public IconComponent getEraserIcon() {
        return eraserIcon;
    }

    public void setEraserIcon(IconComponent eraserIcon) {
        this.eraserIcon = eraserIcon;
    }

    public IconComponent getPencilIcon() {
        return pencilIcon;
    }

    public void setPencilIcon(IconComponent pencilIcon) {
        this.pencilIcon = pencilIcon;
    }

    public IconComponent getBrushIcon() {
        return brushIcon;
    }

    public void setBrushIcon(IconComponent brushIcon) {
        this.brushIcon = brushIcon;
    }

    public IconComponent getHandIcon() {
        return handIcon;
    }

    public void setHandIcon(IconComponent handIcon) {
        this.handIcon = handIcon;
    }

    public IconComponent getMagnifyingGlassIcon() {
        return magnifyingGlassIcon;
    }

    public void setMagnifyingGlassIcon(IconComponent magnifyingGlassIcon) {
        this.magnifyingGlassIcon = magnifyingGlassIcon;
    }

    public IconComponent getMarqeeIcon() {
        return marqeeIcon;
    }

    public void setMarqeeIcon(IconComponent marqeeIcon) {
        this.marqeeIcon = marqeeIcon;
    }

    public IconComponent getPaintCanIcon() {
        return paintCanIcon;
    }

    public void setPaintCanIcon(IconComponent paintCanIcon) {
        this.paintCanIcon = paintCanIcon;
    }

    public IconComponent getEyeDropperIcon() {
        return eyeDropperIcon;
    }

    public void setEyeDropperIcon(IconComponent eyeDropperIcon) {
        this.eyeDropperIcon = eyeDropperIcon;
    }

    public IconComponent getXImageIcon() {
        return xImageIcon;
    }

    public void setXImageIcon(IconComponent xImageIcon) {
        this.xImageIcon = xImageIcon;
    }

    public IconComponent getOvalIcon() {
        return ovalIcon;
    }

    public void setOvalIcon(IconComponent ovalIcon) {
        this.ovalIcon = ovalIcon;
    }

    public IconComponent getArcIcon() {
        return arcIcon;
    }

    public void setArcIcon(IconComponent arcIcon) {
        this.arcIcon = arcIcon;
    }

    public IconComponent getArrowIcon() {
        return arrowIcon;
    }

    public void setArrowIcon(IconComponent arrowIcon) {
        this.arrowIcon = arrowIcon;
    }

    public IconComponent getCircleIcon() {
        return circleIcon;
    }

    public void setCircleIcon(IconComponent circleIcon) {
        this.circleIcon = circleIcon;
    }

    public Vector getIconList() {
        return iconList;
    }

    public void setIconList(Vector iconList) {
        this.iconList = iconList;
    }


    public void setRed(Label red) {
        this.red = red;
    }

    public void setGreen(Label green) {
        this.green = green;
    }

    public void setBlue(Label blue) {
        this.blue = blue;
    }

    public Label getXPosition() {
        return xPosition;
    }

    public void setXPosition(Label xPosition) {
        this.xPosition = xPosition;
    }

    public Label getYPosition() {
        return yPosition;
    }

    public void setYPosition(Label yPosition) {
        this.yPosition = yPosition;
    }

    public void setSelectedIcon(IconComponent selectedIcon) {
        this.selectedIcon = selectedIcon;
    }

}


