package gui.run;

import javax.swing.*;
import java.awt.event.ActionListener;


public abstract class RunTextFieldOld extends
        JTextField implements ActionListener, Runnable {
    private String sTxt;
    private String originalText = null;

    public String getOriginalText() {
        return originalText;
    }

    public RunTextFieldOld(String text) {
        super(text);
        originalText = text;
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
    }


    public RunTextFieldOld() {
        this("");
    }

    public RunTextFieldOld(int columns) {
        super(columns);
        addActionListener(this);
    }

    public RunTextFieldOld(String text, int columns) {
        super(text, columns);
        addActionListener(this);
    }

    public RunTextFieldOld(javax.swing.text.Document doc, String text, int columns) {
        super(doc, text, columns);
        addActionListener(this);
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        gui.ClosableJFrame cf = new gui.ClosableJFrame("RunTextField");
        java.awt.Container c = cf.getContentPane();
        c.add(new RunTextFieldOld("[aWhat is your name?") {
            public void run() {
                System.out.println(getText());
            }
        });
        c.add(new RunTextFieldOld("[bWhat is your name?") {
            public void run() {
                System.out.println(getText());
            }
        });
        c.setLayout(new java.awt.GridLayout(4, 0));
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

}