package gui.run;


import gui.In;

import javax.swing.*;
import java.awt.*;

public class RunMenu extends
        JMenu {

    public RunMenu(String s) {
        super(s);
        ShortcutUtils.addShortcut(this);
    }

    public RunMenu() {
        super("");
    }

    // Because the mnemonics only have to be unique within a given menu, we intercept each
    // added menuitem (see overriden add methods below) prior to adding it to the list.
    // This interception allows us to test the preexising components of the menu to
    // see if the mnemonic already exists.
    // We test and recast to AbstractButton because that is the most primitive class where
    // Mnemonics are meaningful.--RJD
    private void testMenuForDuplicateMnemonics(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton a = (AbstractButton) c;
            Component myMenuItems[] = getMenuComponents();
            checkForDups(myMenuItems, a);
        }
    }

    private static final void checkForDups(Component[] myMenuItems, AbstractButton a) {
        for (int index = 0; index < myMenuItems.length; index++)
            processEachComponent(a, myMenuItems, index);
    }

    private static void processEachComponent(AbstractButton a,
                                             Component[] myMenuItems,
                                             int index) {
        if (!(myMenuItems[index] instanceof AbstractButton)) return;
        AbstractButton b = (AbstractButton) myMenuItems[index];
        if (a == b) return;
        int aMnemonic = a.getMnemonic();
        int bMnemonic = b.getMnemonic();
        if (aMnemonic == 0) return;
        if (bMnemonic == 0) return;
        if (aMnemonic == bMnemonic) {
            In.message("warning, duplicate mnemonics detected " + a.getText() +
                    " : " + b.getText());
        }
    }

    // must override all add functions in order to test for mnemonic clashes
    public Component add(Component c) {
        testMenuForDuplicateMnemonics(c);
        return super.add(c);
    }

    // must override all add functions in order to test for mnemonic clashes
    public Component add(Component c, int index) {
        testMenuForDuplicateMnemonics(c);
        return super.add(c, index);
    }

    // must override all add functions in order to test for mnemonic clashes
    public JMenuItem add(JMenuItem c) {
        testMenuForDuplicateMnemonics(c);
        return super.add(c);
    }

}