package gui.run;

import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Mar 31, 2004
 * Time: 7:18:20 PM
 */
public class RunLabel extends JLabel {
    RunLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        ShortcutUtils.addShortcut(this);
    }

    public RunLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public RunLabel(String text) {
        this(text, null, LEADING);
    }

    public RunLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public RunLabel(Icon image) {
        this(null, image, CENTER);
    }

    public RunLabel() {
        this("", null, LEADING);
    }

    public static void main(String[] args) {
        ClosableJFrame cj = new ClosableJFrame();
        Container c = cj.getContentPane();
        c.setLayout(new FlowLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add(new RunLabel("[Name"));
        RunTextFieldOld runTextFieldOld = new RunTextFieldOld("[Name") {
            public void run() {

            }
        };
        runTextFieldOld.setText("");
        textFieldPanel.add(runTextFieldOld);
        labelPanel.add(new RunLabel("[House/Street"));
        textFieldPanel.add(new RunTextFieldOld("[House") {
            public void run() {

            }
        });
        c.add(textFieldPanel);
        c.add(labelPanel);
        cj.setSize(200, 200);
        cj.show();
    }

}
