package gui.run;

import gui.ClosableJFrame;
import gui.layouts.Alignable;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public abstract class RunComboBox extends JComboBox
        implements ActionListener, Alignable,
        Runnable {
    private int alignment = Alignable.CENTER;

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return alignment;
    }

    public RunComboBox(Object items[]) {
        super(items);
        addActionListener(this);
    }

    public RunComboBox(Vector items) {
        super(items);
        addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        // anonymous inner class
        // That uses the command pattern
        // also uses adapter pattern
        // since the normal
        // requires an
        // actionListener-
        // actionPerformed(ActionEvent e)
        // now we just need a run method.
        // Semantics for the runButton now include
        // an implicit metaChar='['


        final ClosableJFrame cf =
                new ClosableJFrame("OK-CANCEL Frame");
        final Container c = cf.getContentPane();
        c.setLayout(new BoxLayout(c, BoxLayout.PAGE_AXIS));
        Vector v = new Vector();
        v.addElement("tom");
        v.addElement("dick");
        v.addElement("harry");
        c.add(new RunComboBox(v) {
            public void run() {
                System.out.println(this.getSelectedItem());
                c.setLayout(new BoxLayout(c, BoxLayout.PAGE_AXIS));
                cf.pack();
            }
        });
        c.add(new RunComboBox(v) {
            public void run() {
                c.setLayout(new BoxLayout(c, BoxLayout.LINE_AXIS));
                cf.pack();
            }
        });
        c.add(new RunComboBox(v) {
            public void run() {
                c.setLayout(new BoxLayout(c, BoxLayout.X_AXIS));
                cf.pack();
            }
        });
        c.add(new RunComboBox(v) {
            public void run() {
                BoxLayout boxLayout = new BoxLayout(c, BoxLayout.Y_AXIS);
                c.setLayout(boxLayout);
                cf.pack();
            }
        });
        c.add(new RunComboBox(v) {
            public void run() {
                c.setLayout(new FlowLayout());
                cf.pack();
            }
        });
        cf.setSize(200, 200);
        cf.show();
    }
}