package gui.run;

// Fig. 25.33: SliderFieldPanel.java
// A subclass of JPanel containing a JSlider and a JTextField


import gui.ClosableJFrame;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.io.Serializable;

/**
 * Only works for integers. Shows a textfield and
 * a slider, as well as a label. Shortcut
 * mnemonics are used in the label to focus onto
 * the textfield.
 *
 * @see RunSlider
 */
public class IntegerRunSliderPanel
        extends JPanel
        implements Serializable {
    private RunTextFieldOld tf;
    private int currentValue;

    // object to support bound property changes
    //private PropertyChangeSupport changeSupport;
    private RunSlider slider;
    private RunLabel nameLabel = null;

    public IntegerRunSliderPanel(String name,
                                 RunSlider rs) {
        slider = rs;
        nameLabel = new RunLabel(name);
        // create PropertyChangeSupport for bound properties
        //changeSupport = new PropertyChangeSupport(this);
        tf = new RunTextFieldOld(String.valueOf(slider.getValue()),
                5) {
            public void run() {
                setValue(parseInt());
            }
        };
        ShortcutUtils.addFocusAccelerator(name,
                tf);
        setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(tf);
        jp.add(nameLabel);
        add(jp, BorderLayout.WEST);
        add(slider, BorderLayout.CENTER);

        slider.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                setValue(slider.getValue());
            }
        });
        this.invalidate();
    }

    private int parseInt() {
        try {
            return Integer.parseInt(tf.getText());
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    // property minimumValue
    public void setMinimumValue(int min) {
        slider.setMinimum(min);

        if (slider.getValue() <
                slider.getMinimum()) {
            slider.setValue(slider.getMinimum());
            tf.setText(String.valueOf(slider.getValue()));
        }
    }

    public int getMinimumValue() {
        return slider.getMinimum();
    }

    // property maximumValue
    public void setMaximumValue(int max) {
        slider.setMaximum(max);

        if (slider.getValue() >
                slider.getMaximum()) {
            slider.setValue(slider.getMaximum());
            tf.setText(String.valueOf(slider.getValue()));
        }
    }

    public int getMaximumValue() {
        return slider.getMaximum();
    }

    /**
     * Sets the current value of both the slider
     * and the textfield
     *
     * @param n
     */
    public void setValue(int n) {
        currentValue = n;
        slider.setValue(currentValue);
        tf.setText(String.valueOf(currentValue));
    }

    /**
     * @return value of the slider
     */
    public int getValue() {
        return slider.getValue();
    }

    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());
        c.add(new IntegerRunSliderPanel("slider [1",
                new RunSlider(1, 1000) {
                    public void run() {
                        System.out.println(getValue());

                    }
                }));
        c.add(new IntegerRunSliderPanel("s [2", new RunSlider(-50, 50) {
            public void run() {
            }
        }));
        c.add(new IntegerRunSliderPanel("slider [3", new RunSlider(1, 5) {
            public void run() {

            }
        }));
        cf.setSize(400, 400);
        cf.show();
    }
}
