package gui.icons;

// gui.ImageUtils

import j2d.ImageUtils;
import gui.run.RunButton;
import gui.icons.Icons;
import j2d.color.PseudoColorFilter;
import j2d.hpp.HppFilterImageProcessor;
import math.Mat2;

import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;

public class IconUtils {


    private static Image originalImage = null;


    public static void main(String args[]) {
        JFrame f = new gui.ClosableJFrame();
        f.setSize(200, 200);
        addJTabbedPane(f);


        f.setSize(400, 400);
        f.setVisible(true);
    }

    private static void addJTabbedPane(JFrame f) {
        JTabbedPane jtp = new JTabbedPane();
        Container c = f.getContentPane();
        c.setLayout(new BorderLayout());
        OpenImageButton pseudoColorButton =
                new OpenImageButton();
        jtp.addTab("PseudoColorController", null,
                new PseudoColorController(pseudoColorButton),
                "PseudoColorController");


        c.add(jtp, BorderLayout.NORTH);
        c.add(pseudoColorButton, BorderLayout.CENTER);
    }


    public static void updateImage(
            double ar, double ag, double ab,
            RunButton rb) {
        //BufferedImage obi = ImageUtils.getBufferedImage(originalImage);
        //jaiPColor(ar, ag, ab, obi, rb);
        if (originalImage == null) {
            rb.setIcon(Icons.getColorCameramanIcon(ar, ag, ab));
            return;
        }

        ImageIcon ic = new ImageIcon(
                HppFilterImageProcessor.getImage(
                        originalImage,
                        new PseudoColorFilter(ar, ag, ab)
                )
        );
        rb.setIcon(ic);
    }

    private static void jaiPColor(double ar, double ag, double ab,
                                  BufferedImage obi, RunButton rb) {
        float[][] colorMatrix = {
            {(float) ar, 0f, 0f},
            {1f, (float) ab, 1f},
            {1f, 1f, (float) ag}};
        BufferedImage bi = ImageUtils.changeColors(colorMatrix, obi);
        rb.setIcon(new ImageIcon(ImageUtils.getImage(bi)));
        rb.setSize(bi.getWidth(), bi.getHeight());
    }

    private static void PseudoColorButton(RunButton rb, double ar, double ag, double ab) {
        Image img = getImage(rb);
        img = ImageUtils.getImage(img,
                new PseudoColorFilter(ar, ag, ab));
        rb.setIcon(new ImageIcon(img));
    }

    private static Image getImage(RunButton rb) {
        ImageIcon icn = (ImageIcon) rb.getIcon();
        Image img = icn.getImage();
        return img;
    }

    public static Icon getColorIcon(short r[][]) {
        return new ImageIcon(
                ImageUtils.getImage(r,
                        new PseudoColorFilter()));
    }

    public static Icon getColorIcon(short r[][], double ar, double ag, double ab) {
        short g[][] = Mat2.copy(r);
        short b[][] = Mat2.copy(r);
        return new ImageIcon(
                ImageUtils.getImage(r, g, b,
                        new PseudoColorFilter(ar, ag, ab)));
    }

    public static Icon getIcon(short r[][]) {
        return new ImageIcon(
                ImageUtils.short2Image(r));
    }


    public static class OpenImageButton extends RunButton {
        public OpenImageButton() {
            super(Icons.getColorCameramanIcon());
            originalImage =
                    ((ImageIcon) super.getIcon()).getImage();

        }

        public void run() {
            originalImage = ImageUtils.getImage();
            setIcon(new ImageIcon(originalImage));
        }

        private Image getIconImage() {
            ImageIcon ic = (ImageIcon) super.getIcon();
            return ic.getImage();
        }

    }

}