package gui.html;

import gui.ClosableJFrame;
import gui.In;

import javax.swing.*;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import java.io.File;
import java.io.PrintWriter;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;


public class TextViewer extends ClosableJFrame {

    private JEditorPane textPane
            = new JEditorPane();
    private File outputFile = null;
    private boolean logsToFile = false;
    private PrintWriter pw = null;

    public void setVisible(boolean isVisible){
        if (logsToFile) setVisible(false);
        if (!logsToFile) setVisible(isVisible);
    }

    public void setLogToFile(boolean logsToFile, File outputFile){
        if(!logsToFile) return;

        this.outputFile = outputFile;
        if (!isValidOutputFile()) return;
        this.logsToFile = logsToFile;
        In.message("output to:"+this.outputFile.getAbsolutePath());
        try {
            pw = new PrintWriter(new FileOutputStream(outputFile));
        } catch (FileNotFoundException e) {
            In.message(e);

        }
    }
    private boolean isValidOutputFile(){
        if (outputFile == null) return false;
        if (outputFile.canWrite()) return true;
        return false;
    }

    public TextViewer() {
        super("TextViewer");
        java.awt.Container c = getContentPane();
        c.setLayout(new java.awt.GridLayout(1, 0));
        c.add(new JScrollPane(textPane));
        setSize(400, 400);
        textPane.setAutoscrolls(false);
    }


    public void setRtfText(String s) {
        textPane.setContentType("text/rtf");
        textPane.setText(s);
    }

    public void setPlainText(String s) {
        textPane.setContentType("text/plain");
        textPane.setText(s);
    }

    public void setString(String s) {
        setPlainText(s);
        System.out.println(s);
    }
    public void close(){
        setVisible(false);
        pw.close();
    }
    /**
     * A println that will only display if
     * the view is not designed to log to a file.
     * @param o
     */
    public void println(Object o) {
        if (logsToFile) {
            pw.println(o);
            return;
        }
        if (!isVisible()) show();
        if (o == null) return;
        StringBuffer sb = new StringBuffer(textPane.getText());
        sb.append("\n")
                .append(o.toString());
        textPane.setText(sb.toString());
        //autoScroll();

    }
    public void autoScroll()  {
        try {
            Document doc = textPane.getDocument();
            int length = doc.getLength();
            textPane.setCaretPosition(length);
            textPane.scrollRectToVisible(textPane.modelToView(length - 1));
        } catch (BadLocationException e) {


        }
    }


    public static void main(String args[]) {
        TextViewer tv = new TextViewer();
        tv.println("Hello World");
        for (int i = 0; i < 100; i++)
            tv.println("i=" + i);
    }
}