package gui.dialogs;

import javax.swing.*;
import java.awt.*;

public class JBuilderPanel extends JPanel {
    // Constants

    private static final String[] COUNTRY_LIST =
            {
                "Australia", "England", "Japan", "USA"
            };

    // Attributes

    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel myCustomerCodeLabel = new JLabel();
    private JTextField myCustomerCodeField = new JTextField();
    private JLabel myNameLabel = new JLabel();
    private JTextField myNameField = new JTextField();
    private JLabel myAddressLabel = new JLabel();
    private JScrollPane myAddressScrollpane = new JScrollPane();
    private JTextArea myAddressField = new JTextArea();
    private JLabel myCityLabel = new JLabel();
    private JTextField myCityField = new JTextField();
    private JLabel myStateLabel = new JLabel();
    private JTextField myStateField = new JTextField();
    private JLabel myPostcodeLabel = new JLabel();
    private JTextField myPostcodeField = new JTextField();
    private JLabel myCountryLabel = new JLabel();
    private JComboBox myCountryField = new JComboBox(COUNTRY_LIST);
    private JLabel myContactLabel = new JLabel();
    private JTextField myContactField = new JTextField();
    private JLabel myPhoneLabel = new JLabel();
    private JTextField myPhoneField = new JTextField();
    private JLabel myFaxLabel = new JLabel();
    private JTextField myFaxField = new JTextField();
    private JLabel myEmailLabel = new JLabel();
    private JTextField myEmailField = new JTextField();
    private JLabel myFillLabel = new JLabel();

    // Methods

    /**
     * This method is the default constructor.
     */
    public JBuilderPanel() {
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * This method initialises the components on the panel.
     */
    private void jbInit() throws Exception {
        this.setLayout(gridBagLayout1);
        this.setBorder(BorderFactory.createEtchedBorder());
        myCustomerCodeLabel.setText("Customer Code");
        myNameLabel.setText("Name");
        myAddressLabel.setText("Address");
        myAddressField.setRows(3);
        myAddressField.setColumns(20);
        myAddressScrollpane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        myAddressScrollpane.getViewport().add(myAddressField, null);
        myCityLabel.setText("City");
        myStateLabel.setText("State");
        myPostcodeLabel.setText("Postcode");
        myCountryLabel.setText("Country");
        myContactLabel.setText("Contact");
        myPhoneLabel.setText("Phone");
        myFaxLabel.setText("Fax");
        myEmailLabel.setText("Email");
        this.add(myCustomerCodeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myCustomerCodeField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 0, 0, 0), 0, 0));
        this.add(myNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myAddressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myAddressScrollpane, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myCityLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myCityField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myStateLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myStateField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myPostcodeLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myPostcodeField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myCountryLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myCountryField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myContactLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myContactField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myPhoneLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myPhoneField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myFaxLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myFaxField, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myEmailLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0
                , GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
        this.add(myEmailField, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
        this.add(myFillLabel, new GridBagConstraints(0, 99, 1, 1, 0.0, 1.0
                , GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
    }

    /**
     * This method gets the values of the panel entry fields.
     *
     * @return an object containing the Customer data
     */
    public CustomerData getCustomerData() {
        CustomerData customerData = new CustomerData();

        customerData.setCustomerCode(myCustomerCodeField.getText());
        customerData.setName(myNameField.getText());
        customerData.setAddress(myAddressField.getText());
        customerData.setCity(myCityField.getText());
        customerData.setState(myStateField.getText());
        customerData.setZip(myPostcodeField.getText());
        customerData.setCountry(myCountryField.getSelectedItem().toString());
        customerData.setContact(myContactField.getText());
        customerData.setPhone1(myPhoneField.getText());
        customerData.setFax(myFaxField.getText());
        customerData.setEmail(myEmailField.getText());

        return customerData;
    }

    /**
     * This method sets the values of the panel entry fields.
     *
     * @param customerData The object containing the Customer data
     */
    public void setCustomerData(CustomerData customerData) {
        myCustomerCodeField.setText(customerData.getCustomerCode());
        myNameField.setText(customerData.getName());
        myAddressField.setText(customerData.getAddress());
        myCityField.setText(customerData.getCity());
        myStateField.setText(customerData.getState());
        myPostcodeField.setText(customerData.getZip());
        myCountryField.setSelectedItem(customerData.getCountry());
        myContactField.setText(customerData.getContact());
        myPhoneField.setText(customerData.getPhone1());
        myFaxField.setText(customerData.getFax());
        myEmailField.setText(customerData.getEmail());
    }

    /**
     * This method demonstrates the usage of the JBuilderPanel class.
     */
    public static void main(String[] args) {
        // Create an instance of the panel

        JBuilderPanel panel = new JBuilderPanel();

        // Create a dialog to hold the panel

        ModalDialog dialog = new
                ModalDialog((Frame) null,
                        "Customer Details (JBuilderPanel)");

        dialog.setContentPane(panel);

        dialog.pack();

        // Present it to a User

        dialog.show();

        // Get the data and display it

        if (!dialog.hasUserCancelled()) {
            CustomerData customerData = panel.getCustomerData();

            customerData.printData();
        }

        System.exit(0);
    }
}