package gui.dialogs;

import gui.run.RunButton;
import utils.SystemUtils;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.io.File;
import java.io.Serializable;

public class DirectoryChooser extends JDialog
        implements TreeExpansionListener,Serializable {

    public static final int WIDTH = 400;
    public static final int HEIGHT = 340;
    DefaultMutableTreeNode root;
    JTree directoryJTree;
    private String selectedDirectory;
    String fileSeparator = SystemUtils.getDirectorySeparator();


    public static void main(String[] args) {
        String directory = getDirectory("select a directory");
        System.out.println("you selected:" + directory);

    }

    public static String getDirectory(String prompt) {
        DirectoryChooser dc = new DirectoryChooser(null, true);
        dc.setTitle(prompt);
        dc.show();
        String directory = dc.getSelectedDirectory();
        return directory;
    }

    class TreeCellRenderer extends DefaultTreeCellRenderer {


        public Component getTreeCellRendererComponent(JTree tree,
                                                      Object value,
                                                      boolean selected,
                                                      boolean expanded,
                                                      boolean leaf,
                                                      int row,
                                                      boolean hasFocus) {
            if (leaf)
                return super.getTreeCellRendererComponent(tree,
                        value,
                        selected,
                        expanded,
                        false,
                        row,
                        hasFocus);
            else
                return super.getTreeCellRendererComponent(tree,
                        value,
                        selected,
                        expanded,
                        leaf,
                        row,
                        hasFocus);
        }

        TreeCellRenderer() {
        }
    }


    public DirectoryChooser(Frame owner, boolean allowCreate) {
        super(owner, "Directory Chooser", true);

        root = new DefaultMutableTreeNode("Directory");
        directoryJTree = new JTree(root);
        Container container = getContentPane();
        container.setLayout(new BorderLayout());
        JLabel label = new JLabel("Please select a directory");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(new RunButton("ok") {
            public void run() {
                doOk();
            }
        });
        if (allowCreate)
            buttonPanel.add(new RunButton("create") {
                public void run() {
                    doCreate();
                }
            });
        directoryJTree.setCellRenderer(new TreeCellRenderer());
        directoryJTree.addTreeExpansionListener(this);
        constructTree();
        container.add(label, "North");
        container.add(new JScrollPane(directoryJTree), "Center");
        container.add(buttonPanel, "South");
        setSize(400, 340);
    }

    private void constructTree() {
        File directoryRoot[] = File.listRoots();
        for (int i = 0; i < directoryRoot.length; i++) {
            DefaultMutableTreeNode tempNode = new DefaultMutableTreeNode(
                    directoryRoot[i]);
            foundSubDirectory(tempNode, directoryRoot[i]);
            root.add(tempNode);
        }

        directoryJTree.setModel(new DefaultTreeModel(root));


        SwingUtilities.updateComponentTreeUI(directoryJTree);


    }


    private void restoreTreeToLastKnownState(String lastSelectedDirectory) {
        TreeExpansionEvent event = new TreeExpansionEvent(this,
                new TreePath(lastSelectedDirectory));
        treeExpanded(event);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        setCursor(new Cursor(3));
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode) event.getPath()
                .getLastPathComponent();
        for (int i = 0; i < selectedNode.getChildCount(); i++) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode) selectedNode.getChildAt(
                    i);
            if (childNode.isLeaf())
                foundSubDirectory(childNode,
                        (File) childNode.getUserObject());
        }

        setCursor(new Cursor(0));
    }

    private void foundSubDirectory(DefaultMutableTreeNode currentNode,
                                   File directory) {
        File fileList[] = directory.listFiles();
        if (fileList == null)
            return;
        for (int i = 0; i < fileList.length; i++)
            if (fileList[i].isDirectory())
                currentNode.add(new DefaultMutableTreeNode(fileList[i]) {

                    public String toString() {
                        return ((File) getUserObject()).getName();
                    }

                });

    }

    public void treeCollapsed(TreeExpansionEvent treeexpansionevent) {
    }


    private void doCreate() {
        Object selectedObject = directoryJTree.getLastSelectedPathComponent();
        if (selectedObject == null || selectedObject == root) {
            JOptionPane.showMessageDialog(this,
                    "Please select a parent for the new directory",
                    "Error",
                    1);
            return;
        }
        String nameOfCreation = JOptionPane.showInputDialog(this,
                "Please enter the name of the new directory",
                "");
        if (nameOfCreation == null ||
                nameOfCreation.trim().equals("")) {
            JOptionPane.showMessageDialog(this,
                    "Please enter the name of the new directory",
                    "Error",
                    1);
            return;
        }
        File selectDirectory = (File) ((DefaultMutableTreeNode) selectedObject).getUserObject();
        if (JOptionPane.showConfirmDialog(this,
                "Create directory " +
                nameOfCreation +
                " to " +
                selectDirectory.getAbsolutePath() +
                "?",
                "Confirmation",
                0) ==
                0) {
            File newDirectory = new File(selectDirectory.getAbsolutePath() +
                    fileSeparator +
                    nameOfCreation);
            if (newDirectory.mkdir()) {
                DefaultMutableTreeNode newLead = new DefaultMutableTreeNode(
                        newDirectory);
                ((DefaultMutableTreeNode) selectedObject).add(newLead);
                TreePath path = directoryJTree.getLeadSelectionPath();
                directoryJTree.setModel(new DefaultTreeModel(root));
                directoryJTree.expandPath(path);
                path = path.pathByAddingChild(newLead);
                directoryJTree.setSelectionPath(path);
                SwingUtilities.updateComponentTreeUI(directoryJTree);
            } else {
                JOptionPane.showMessageDialog(this,
                        "Unexpected error",
                        "Error",
                        0);
            }
        }
    }

    private void doOk() {
        Object selectedDirectory = directoryJTree.getLastSelectedPathComponent();

        if (selectedDirectory == null)
            return;
        this.selectedDirectory =
                ((File) ((DefaultMutableTreeNode) selectedDirectory
                ).getUserObject()).getAbsolutePath();
        hide();
        getParent().remove(this);
    }



    public String getSelectedDirectory() {
        return selectedDirectory;
    }

}
