package gui.dialogs;

import classUtils.reflection.MethodList;
import gui.run.RunPasswordField;
import gui.run.RunTextField;
import gui.run.RunButton;
import security.WebStartBean;

import javax.swing.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * This class demonstrates the usage of the
 * StandardDialog class.
 */
public class BeanDialog extends JDialog {
    Object object = null;
    Class c = null;

    MethodList methodList = null;
    Method writeMethods[] = null;

    private LabeledItemPanel labeledPanelItem =
            new LabeledItemPanel();

    public BeanDialog(Object o) {
        object = o;
        c = o.getClass();
        setTitle(c.getName()+" Dialog");
        methodList = new MethodList(c);
        writeMethods =
                methodList.getWriteMethods();
        init();
    }

    private void init() {

        for (int i = 0;
             i < writeMethods.length;
             i++) {
            final Method setter = writeMethods[i];

            if (hasStringClassParameter(setter))
                addLabeledTextField(setter);

        }
        labeledPanelItem.setBorder(
                BorderFactory.createEtchedBorder());
        labeledPanelItem.addItem("Process", new RunButton("OK") {
            public void run() {

                okPressed();
            }
        });
        JScrollPane jsp = new JScrollPane(labeledPanelItem);
        setContentPane(jsp);
    }
    public void okPressed() {
        setVisible(false);
    }
    private void addLabeledTextField(
            final Method setter) {

        String propertyName = MethodList.getPropertyName(
                setter);
        final Method getter = methodList.getReadMethod(
                setter);
        String value = invoke(getter, null);
        if (MethodList.hasPasswordProperty(
                setter))
            addLabeledRunPasswordField(value,
                    setter,
                    propertyName);
        else
            addLabeledRunTextField(value,
                    setter,
                    propertyName);

    }

    private void addLabeledRunPasswordField(
            String value,
            final Method setter,
            String propertyName) {
        RunPasswordField rtf = new RunPasswordField(
                value, 20) {
            Object args[] = {""};

            public void run() {
                args[0] =
                        this.getPasswordString();
                invoke(setter, args);
            }
        };

        labeledPanelItem.addItem(propertyName,
                rtf);
    }

    private void addLabeledRunTextField(
            String value,
            final Method setter,
            String propertyName) {
       // int lengthOfValue = value.length();

        RunTextField rtf = new RunTextField(
                value, 20) {
            Object args[] = {""};

            public void run() {
                args[0] = getText();
                invoke(setter, args);
            }
        };

        labeledPanelItem.addItem(propertyName,
                rtf);
    }



    private String invoke(final Method m,
                          Object args[]) {
        String value = "";
        try {
            value =
                    (String) m.invoke(object,
                            args);
        } catch (IllegalAccessException e) {
            e.printStackTrace();

        } catch (InvocationTargetException e) {
            e.printStackTrace();

        }
        return value;
    }

    private boolean hasStringClassParameter(
            Method m) {
        Class params[] = m.getParameterTypes();
        Class stringClass = String.class;
        return (params[0].equals(stringClass));
    }

    /**
     * This method gets the values of the panel
     * entry fields.
     *
     * @return Gui modified instance
     */
    public Object getData() {
        return object;
    }


    public static void main(String[] args) {
        BeanDialog dialog = new BeanDialog(
                 WebStartBean.getFromPreferences());
        //WebStartBean.getDefaultWebStartBean());
        dialog.pack();
        dialog.show();
        Object o = dialog.getData();

        System.out.println(o);
    }
}