package graphics.raytracers.rmiRaytracer.raytracer;

import java.awt.*;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

class ImageCanvas extends Canvas {

    Image img;

    DoImageClientManager dicm = new DoImageClientManager();

    public ImageCanvas(
            Dimension band, int size) {
        DoImageInterface di = dicm.getNextProxy();
        //       DoImageClient.getNextInterface();

        try {
            computeTheImage(di, size, band);
        } catch (java.rmi.RemoteException e) {
            e.printStackTrace();
        }
    }

    private void computeTheImage(DoImageInterface di, int size, Dimension band)
            throws java.rmi.RemoteException {
        if (di == null) {
            System.out.println("ERROR:ImageCanvas di==null");
            return;
        }
        di.setSize(new Dimension(size, size));
        di.setBand(band);
        di.doTheWork();
        int pix[][] = di.getSubPixels();
        img = int2Image(pix);
    }

    public static Image int2Image(int i[][]) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        int width = i.length;
        int height = i[0].length;
        int pels[] = new int[width * height];
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++)
                pels[x + y * width] = i[x][y];
        return tk.createImage(
                new MemoryImageSource(width, height,
                        ColorModel.getRGBdefault(),
                        pels, 0, width));
    }

    public ImageCanvas(Image _img) {
        img = _img;
    }

    public void paint(Graphics g) {
        Dimension d = getSize();
        if (img != null)
            g.drawImage(img, 0, 0,
                    d.width, d.height, this);
    }

    public Image getImage() {
        return img;
    }

    public void setImage(Image img) {
        this.img = img;
        repaint();
    }
}
