package futils;

import futils.filters.DirFilter;
import gui.In;
import gui.dialogs.SelectorDialog;

import java.io.File;
import java.io.FileFilter;
import java.util.Vector;

// futils.FileList

public class FileList {

    // This vector will hold all the file names.
    private  Vector v = new Vector();

    public  File[] getFiles() {
        File f[] = new File[v.size()];
        v.copyInto(f);
        return f;
    }

    private static FileFilter ff = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    };
    private static final DirFilter df = new DirFilter();

    // Recurse through all subdirectories and store
    // all the file names in a vector.
    public  void list(File directory) {

        add(directory.listFiles(ff));
        String dirs[] = directory.list(df);

        if (dirs == null) return;

        for (int i = 0; i < dirs.length; i++) {
            list(new File(directory, dirs[i]));
        }
    }

    public  void list(File directory, WildFilter wf) {

        add(directory.listFiles(wf));
        String dirs[] = directory.list(df);

        if (dirs == null) return;

        for (int i = 0; i < dirs.length; i++) {
            list(new File(directory, dirs[i]), wf);
        }
    }

    public  void delete() {
        File f[] = getFiles();
        for (int i = 0; i < f.length; i++) {
            f[i].delete();
        }
    }

    private  void add(File f[]) {
        if (f != null) {
            for (int i = 0; i < f.length; i++)
                v.addElement(f[i]);
        }
    }

    public  void print() {
        int VectorSize = v.size();
        for (int i = 0; i < VectorSize; i++)
            System.out.println(v.elementAt(i));
    }

    public  void deleteAllClassFiles() {
        File f =
                Futil.getReadDirFileJTree("select a directory for deletion (DANGER!!)");
        WildFilter wf = new WildFilter(".class");
        list(f, wf);
        File walkingDeadFiles [] = getFiles();
        boolean b = In.getBoolean("do you really want to delete:"+walkingDeadFiles.length+"files?");
        if (b) delete(walkingDeadFiles);
        else In.message("operation aborted");
    }
    public static void delete(File f[]){
        for (int i=0; i < f.length; i++)
            f[i].delete();
        In.message("files deleted!");
    }

    public static void main(String args[]) {
        testFileLister();

    }
    public int getNumberOfFiles() {
        return v.size();
    }
    private static void testFileLister() {
        FileList fl = new FileList();
        File f =
                Futil.getReadDirFileJTree("select a start file");
        WildFilter wf = new WildFilter(".jar");
        fl.list(f, wf);
        fl.print();

        System.out.println("-----------------------");
        System.out.println("Total number of files = "
                + fl.getNumberOfFiles());
        String s[] = SelectorDialog.getStringSelectorDialog(fl.getFiles());
        for (int i=0; i < s.length; i++)
            System.out.println(s[i]);

    }
}