/*
 * SwitchTest.java
 *
 * Created on October 30, 2002, 1:18 PM
 */

package collections.stringswitch;

import utils.Timer;

/*
 *  SwitchTest.java
 *  Shows how to use the StringSwitch class to use switch based on strings.
 *  Runs performance tests.
 *
 *  @author Thomas Rowland
 *  @version november 5, 2002
 */

public class SwitchTest extends StringSwitch {

    static SwitchTest st;
    static Timer timer;
    static int COUNT;
    static final int ITER = 20;

    // StringSwitch constants
    public final int QUIT = 0;
    public final int DIR = 1;
    public final int RUN = 2;
    public final int STOP = 3;
    public final int DEBUG = 4;
    public final int FWD = 5;
    public static final int REV = 6;

    /** Creates a new instance of SwitchTest */
    public SwitchTest() {

        /* Add the String/int pairs to the hashmap.
           key=String, value=static final int */
        add("quit", 0);
        add("dir", 1);
        add("run", 2);
        add("stop", 3);
        add("debug", 4);
        add("forward", 5);
        add("reverse", 6);
    }

    /** Tests StringSwitch */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: stringswitch.SwitchTest [COUNT]");
            System.exit(0);
        }

        COUNT = Integer.parseInt(args[0]);
        System.out.println("COUNT = " + COUNT + "\n");

        //st = new SwitchTest();
        SwitchTest switchtest = new SwitchTest();
        timer = new Timer();

        /*  Test If-Then where match is at bottom */
        switchtest.runIfThen("reverse");

        /*  Test If-Then where match is at top */
        switchtest.runIfThen("quit");

        /*  Test Switch with a (String) */
        switchtest.runStringSwitch("reverse");

        /*  Test Switch with an (int) */
        switchtest.runIntSwitch(REV);

    }


    /**
     *  switch structure that accepts Strings.
     *  @param s the search String
     */
    private void doStringSwitch(String s) {
        switch (getIdForString(s)) {
            case QUIT:
                //System.out.print ("QUIT=" + QUIT);
                break;
            case DIR:
                //System.out.print ("DIR=" + DIR);
                break;
            case RUN:
                //System.out.print ("RUN=" + RUN);
                break;
            case STOP:
                //System.out.print ("STOP=" + STOP);
                break;
            case DEBUG:
                //System.out.print ("DEBUG=" + DEBUG);
                break;
            case FWD:
                //System.out.print ("FWD=" + FWD);
                break;
            case REV:
                //System.out.print ("REV=" + REV);
                break;
        }
    }

    /**
     *  Standard switch structure that accepts ints.
     *  @param i the search int
     */
    private void doIntSwitch(int i) {
        switch (i) {
            case QUIT:
                //System.out.print ("QUIT=" + QUIT);
                break;
            case DIR:
                //System.out.print ("DIR=" + DIR);
                break;
            case RUN:
                //System.out.print ("RUN=" + RUN);
                break;
            case STOP:
                //System.out.print ("STOP=" + STOP);
                break;
            case DEBUG:
                //System.out.print ("DEBUG=" + DEBUG);
                break;
            case FWD:
                //System.out.print ("FWD=" + FWD);
                break;
            case REV:
                //System.out.print ("REV=" + REV);
                break;
        }
    }

    /**
     *  if-then structure operating on a String.
     *  @param s the search String
     */
    private void doIf(String s) {
        if (s.equals("quit")) {
            //System.out.print ("QUIT=" + QUIT);
        } else if (s.equals("dir")) {
            //System.out.print ("DIR=" + DIR);
        } else if (s.equals("run")) {
            //System.out.print ("RUN=" + RUN);
        } else if (s.equals("stop")) {
            //System.out.print ("STOP=" + STOP);
        } else if (s.equals("debug")) {
            //System.out.print ("DEBUG=" + DEBUG);
        } else if (s.equals("forward")) {
            //System.out.print ("FWD=" + FWD);
        } else if (s.equals("reverse")) {
            //System.out.print ("REV=" + REV);
        }
    }

    private void runIfThen(String svalue) {
        System.out.println("\nTesting if-then with a String (Bottom)");
        for (int i = 0; i < ITER; i++) {
            timer.clear();
            timer.start();
            for (int j = 0; j < COUNT; j++) {
                st.doIf(svalue);
            }
            timer.stop();
            System.out.println(timer.getElapsedTime());
        }
    }

    private void runIntSwitch(int ivalue) {
        System.out.println("\nTesting Switch with an int");
        for (int i = 0; i < ITER; i++) {
            timer.clear();
            timer.start();
            for (int j = 0; j < COUNT; j++) {
                st.doIntSwitch(ivalue);
            }
            timer.stop();
            System.out.println(timer.getElapsedTime());
        }
    }

    private void runStringSwitch(String svalue) {
        System.out.println("\nTesting Switch with a String");
        for (int i = 0; i < ITER; i++) {
            timer.clear();
            timer.start();
            for (int j = 0; j < COUNT; j++) {
                st.doStringSwitch(svalue);
            }
            timer.stop();
            System.out.println(timer.getElapsedTime());
        }
    }

}

