/*
 * StatInfo.java
 *
 * Created on December 4
 */

package collections.map;

import java.util.Comparator;

/**
 * StarInfo class containing two explicit comparators.
 * @author  Thomas Rowland
 */
public class StarInfo {

    private String name;
    private double distance;

    public static final Comparator
            NAME_COMPARATOR = new NameComparator();

    public static final Comparator
            DIST_COMPARATOR = new DistanceComparator();


    StarInfo(String _name, double _dist) {
        name = _name;
        distance = _dist;
    }

    /* equality based on name field */
    public boolean equals(Object o) {
        if (o.getClass() != this.getClass())
            return false;
        return ((StarInfo) o).getName().equals(name);
    }

    /* hash code based on name field */
    public int hashCode() {
        return name.hashCode();
    }


    public String getName() {
        return name;
    }

    public double getDistance() {
        return distance;
    }

    /* Name Comparator */
    private static class NameComparator
            implements Comparator {
        public int compare(Object o1, Object o2) {
            return ((StarInfo) o1).getName()
                    .compareTo(
                            ((StarInfo) o2).getName());
        }
    }

    /* Distance Comparator */
    private static class DistanceComparator
            implements Comparator {
        public int compare(Object o1, Object o2) {
            return (new Double(((StarInfo) o1)
                    .getDistance()))
                    .compareTo(
                            new Double(((StarInfo) o2)
                    .getDistance()));
        }
    }

}
