/*
 * MapTest.java
 *
 * Created on December 4, 2002
 */

package collections.map;

import java.util.*;

/**
 *
 * @author  Thomas Rowland
 */
public class MapTest {

    static String IMG = "<THE_IMAGE>";  //a fake image

    public static void main(String[] args) {

        MapTest maptest = new MapTest();
        Map hashmap = new HashMap();
        Map treemap;

        //add some data to hashmap
        maptest.fill(hashmap);

        /* copy data into treemap using comparator for sorting */
        treemap = maptest.toTreeMap(hashmap, StarInfo.DIST_COMPARATOR);
        maptest.printData(treemap);

        /* copy data into treemap using comparator for sorting */
        treemap = maptest.toTreeMap(hashmap, StarInfo.NAME_COMPARATOR);
        maptest.printData(treemap);
    }

    private Map fill(Map map) {
        map.put(
                new StarInfo("Sun", 0), IMG);
        map.put(
                new StarInfo("Sirius A,B", 8.60), IMG);
        map.put(
                new StarInfo("Alpha Centauri A,B", 4.39), IMG);
        map.put(
                new StarInfo("Barnard's Star", 5.94), IMG);
        map.put(
                new StarInfo("Epsilon Eridani", 10.50), IMG);
        map.put(
                new StarInfo("Proxima Centauri", 4.22), IMG);
        return map;
    }

    private Map toTreeMap(Map map, Comparator comp) {
        System.out.println("Using comparator " + comp + "\n");
        Map treemap = new TreeMap(comp);
        treemap.putAll(map);
        return treemap;
    }

    private void printData(Map map) {
        Iterator keys = map.keySet().iterator();
        Iterator values = map.values().iterator();
        while (keys.hasNext()) {
            StarInfo key = (StarInfo) keys.next();
            System.out.println(key.getName());
            System.out.println(key.getDistance());
            System.out.println(values.next());
            System.out.println();
        }
    }
}