/*
 * Stack.java
 *
 * Created on December 4, 2002
 */

package collections.linkedlist;

import java.util.LinkedList;

/**
 * Shows how to use a LinkedList as a Stack.
 * @author  Thomas Rowland
 */
public class Stack {

    private static LinkedList list = new LinkedList();

    public static void main(String[] args) {
        Stack stack = new Stack();
        stack.push("good");
        stack.push("bad");
        stack.push("ugly");

        System.out.println(stack.peek());
        System.out.println(stack.pop());
        System.out.println(stack.pop());
        System.out.println(stack.pop());
    }

    /**
     * push an object onto the top of the stack
     */
    public void push(Object o) {
        list.addFirst(o);
    }

    /**
     * pop an object off the top of the stack
     */
    public Object pop() {
        return list.removeFirst();
    }

    /**
     * peek at an object on the top of the stack
     */
    public Object peek() {
        return list.getFirst();
    }
}
