/*
 * Product.java
 *
 * Created on December 3, 2002
 */

package collections.hashset;

/**
 * Demonstrates how to override the hashCode and equals
 * methods to test for equality.
 *
 * @author  Thomas Rowland
 */
public class Product {
    private int id;		// unique
    private String name;
    private String descr;
    private int qty;
    private double priceEa;
    private double priceNet;

    public Product(int _id, String _name,
                   String _descr, int _qty, double _price) {
        id = _id;
        name = _name;
        descr = _descr;
        qty = _qty;
        priceEa = _price;
        priceNet = qty * priceEa;
    }

    /**
     * Overridden hashCode method. This method gets called first when
     * this object is being added or removed from the HashSet.
     */
    public int hashCode() {
        System.out.println("-- hashCode method called.");
        return id;
    }

    /**
     * Overridden equals method. This method gets called when
     * the hash codes from both objects being compared are equal.
     */
    public boolean equals(Object o) {
        System.out.println("-- equals method called.");
        if (o != null && o.getClass().equals(this.getClass()))
            return (id == ((Product) o).getId());
        return false;
    }

    public String toString() {
        return "\nid:" + id +
                "\nname=" + name +
                "\ndescr=" + descr +
                "\nqty=" + qty +
                "\npriceEach=" + priceEa +
                "\npriceNet=" + priceNet;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDescr() {
        return descr;
    }

    public int getQty() {
        return qty;
    }

    public double getPriceEa() {
        return priceEa;
    }

    public double getPriceNet() {
        return priceNet;
    }
}