package classUtils.reflection;

import classUtils.delegate.DelegateSynthesizer;

public class IntrospectUtil extends ReflectUtil {
    private java.beans.MethodDescriptor methodDescriptors[];
    private java.beans.BeanInfo bi = null;
    private java.beans.PropertyDescriptor propertyDescriptors[];

    public IntrospectUtil(Object _o) {
        super(_o);
        try {
            bi = java.beans.Introspector.getBeanInfo(getC());
            methodDescriptors = bi.getMethodDescriptors();
            propertyDescriptors = bi.getPropertyDescriptors();

        } catch (java.beans.IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public static void testIndexedPropertyDescriptors()
            throws java.beans.IntrospectionException {
        print(getIndexedPropertyDescriptors(new java.util.Date()));
    }

    public static void print(java.beans.IndexedPropertyDescriptor ipd[]) {
        System.out.println("Property Names\tProperty Type");
        for (int i = 0; i < ipd.length; i++) {
            System.out.println(ipd[i].getName()
                    +
                    "\t\t"
                    + ipd[i].getPropertyType());
        }
    }

    public static java.beans.PropertyDescriptor[] getIndexedPropertyDescriptors(
            Object o)
            throws java.beans.IntrospectionException {
        Class c = o.getClass();
        java.beans.BeanInfo bi = java.beans.Introspector.getBeanInfo(c);
        return bi.getPropertyDescriptors();
    }


    public static void testPropertyDescriptors()
            throws java.beans.IntrospectionException {
        print(getPropertyDescriptors(new java.util.Date()));
    }

    public static void print(java.beans.PropertyDescriptor pd[]) {
        System.out.println("Property Names\tProperty Type");
        for (int i = 0; i < pd.length; i++) {
            System.out.println(pd[i].getName()
                    +
                    "\t\t"
                    + pd[i].getPropertyType());
        }
    }

    public static java.beans.PropertyDescriptor[] getPropertyDescriptors(
            Object o)
            throws java.beans.IntrospectionException {
        Class c = o.getClass();
        java.beans.BeanInfo bi = java.beans.Introspector.getBeanInfo(c);
        return bi.getPropertyDescriptors();
    }


    public static void testMethodDescriptors()
            throws java.beans.IntrospectionException {
        print(getMethodDescriptors(new java.util.Date()));
    }

    public static void print(java.beans.MethodDescriptor md[]) {
        System.out.println("Method Names");
        for (int i = 0; i < md.length; i++) {
            System.out.print(md[i].getName() + " ");
        }
    }

    public static java.beans.MethodDescriptor[] getMethodDescriptors(
            Object o)
            throws java.beans.IntrospectionException {
        Class c = o.getClass();
        java.beans.BeanInfo bi = java.beans.Introspector.getBeanInfo(c);
        return bi.getMethodDescriptors();
    }


    public String getBeanInfo() {
        return "BeanInfo:"
                +
                getBeanDescriptorString(bi) +
                "\n"
                +
                bi.getEventSetDescriptors() +
                "\n"
                + bi.getPropertyDescriptors();
    }

    // cutils.reflection.IntrospectUtil
    public static void main(String args[]) {
        try {
            testPropertyDescriptors();
        } catch (java.beans.IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public static void testEventSetDescriptors()
            throws java.beans.IntrospectionException {
        print(getEventSetDescriptors(new javax.swing.JButton()));
    }

    public static java.beans.EventSetDescriptor[] getEventSetDescriptors(
            Object o)
            throws java.beans.IntrospectionException {
        Class c = o.getClass();
        java.beans.BeanInfo bi = java.beans.Introspector.getBeanInfo(c);
        return bi.getEventSetDescriptors();
    }


    public static void print(java.beans.EventSetDescriptor esd[]) {
        System.out.println("\n\tListeners\n\t---------");
        for (int i = 0; i < esd.length; i++) {
            System.out.println("(" +
                    (i + 1) +
                    ")\t"
                    +
                    esd[i].getName()
                    +
                    " - "
                    + esd[i].getListenerType());
        }
    }


    public static String getBeanDescriptorString(java.beans.BeanInfo bi) {
        java.beans.BeanDescriptor bd = bi.getBeanDescriptor();
        return bd.getBeanClass().toString()
                +
                "\n"
                +
                "name=" +
                bd.getName()
                +
                "\ngetDisplayName=" +
                bd.getDisplayName()
                +
                "\nisHidden=" +
                bd.isHidden()
                + "\ngetShortDescription=" + bd.getShortDescription();
    }

    public void print() {
        print(getBeanInfo());
    }

    public void print(Object o) {
        System.out.println(o);
    }

    public void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    public static void testIntrospectUtil() {
        IntrospectUtil iu = new IntrospectUtil(new java.util.Vector());
        iu.print();
        DelegateSynthesizer ds = new DelegateSynthesizer();
        ds.add(iu.bi);
        ds.add(iu.methodDescriptors[0]);
        ds.add(iu.propertyDescriptors[0]);
        ds.print();
    }
}
