package classUtils.pack.xml;

import classUtils.pack.util.ListEnumeration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * <font color=red>NOT FUNCTIONAL YET</font>. A JavaBean to display and manage XML in a tree.
 * 
 * 
 * @author cris
 */
public class XmlTree extends JTree {
	
	private static SAXParserFactory defaultSAXParserFactory;
	private TreeNode rootNode;
	

	/**
	 * Constructor XmlTree.
	 * @param xml
	 */
	public XmlTree(SAXParserFactory spf, String xml) throws SAXException, ParserConfigurationException, IOException {
		rootNode=new DocumentRootXmlTreeNode();
		setModel(new DefaultTreeModel(rootNode));
		SAXParser sp = spf.newSAXParser();
		XmlTreeContentHandler ch = new XmlTreeContentHandler(this);
		sp.parse(new ByteArrayInputStream(xml.getBytes()), ch);
		
		((DefaultTreeCellRenderer)getCellRenderer()).setClosedIcon(new ElementXmlIcon());
		((DefaultTreeCellRenderer)getCellRenderer()).setOpenIcon(new ElementXmlIcon());
		((DefaultTreeCellRenderer)getCellRenderer()).setLeafIcon(new ElementXmlIcon());
		
	}

	
	public static void main(String[] args) throws Exception {
		
		String xml = 
			"<?xml version=\"1.0\"?>"+
			"<sadun:test xmlns:sadun=\"http://www.sadun.org\">"+
			" <sadun:internal-element>"+
			"   TextNode"+
			" </sadun:internal-element>"+
			"</sadun:test>";
		
		JFrame frame = new JFrame();
		SAXParserFactory spf = SAXParserFactory.newInstance();
		spf.setValidating(false);
		XmlTree tree = new XmlTree(spf, xml);
		frame.getContentPane().add(tree);
		frame.pack();
		frame.setVisible(true);
		
		
	}
	
}

abstract class BaseXmlTreeNode implements TreeNode {
	
	private List children=new ArrayList();
	private TreeNode parent;
	
	protected BaseXmlTreeNode(TreeNode parent) {
		this.parent=parent;
	}
	
	public void appendChild(BaseXmlTreeNode node) {
		insertChild(node, children.size());
	}
	
	public void insertChildOnTop(BaseXmlTreeNode node) {
		insertChild(node, 0);
	}
	
	public void insertChild(TreeNode node, int index) {
		children.add(index, node);
	}
	
	public void removeChild(int index) {
		children.remove(index);
	}
	
	public void removeChild(TreeNode node) {
		int i;
		if ((i=getIndex(node))==-1) return;
		removeChild(i);
	}
	
	/**
	 * @see javax.swing.tree.TreeNode#children()
	 */
	public Enumeration children() {
		return new ListEnumeration(children);
	}

	/**
	 * @see javax.swing.tree.TreeNode#getChildAt(int)
	 */
	public TreeNode getChildAt(int index) {
		return (TreeNode)children.get(index);
	}

	/**
	 * @see javax.swing.tree.TreeNode#getChildCount()
	 */
	public int getChildCount() {
		return children.size();
	}

	/**
	 * @see javax.swing.tree.TreeNode#getIndex(TreeNode)
	 */
	public int getIndex(TreeNode node) {
		return children.indexOf(node);
	}

	/**
	 * @see javax.swing.tree.TreeNode#getParent()
	 */
	public TreeNode getParent() {
		return parent;
	}
	
	/**
	 * Return the parent, as a BaseXmlTreeNode
	 */
	public BaseXmlTreeNode getXmlParent() {
		return (BaseXmlTreeNode)parent;
	}
	
	

	/**
	 * @see javax.swing.tree.TreeNode#isLeaf()
	 */
	public boolean isLeaf() {
		return children.size()==0;
	}

	/**
	 * @see javax.swing.tree.TreeNode#getAllowsChildren()
	 */
	public boolean getAllowsChildren() {
		return true;
	}
	
	/**
	 * Sets the parent.
	 * @param parent The parent to set
	 */
	public void setParent(TreeNode parent) {
		if (parent==null) throw new RuntimeException("Cannot set parent node as null");
		this.parent = parent;
	}
	
	protected abstract String getLabel();
	
	public String toString() { return getLabel(); }

}

class DocumentRootXmlTreeNode extends BaseXmlTreeNode {
	
	public DocumentRootXmlTreeNode() {
		super(null);
	}
	
	protected String getLabel() { return "/";	}
	
}

abstract class BaseXmlTreeNodeWithNamespace extends BaseXmlTreeNode  {
	
	private String nameSpaceURI;
	
	protected BaseXmlTreeNodeWithNamespace(TreeNode parent, String nameSpaceURI) {
		super(parent);
		this.nameSpaceURI=nameSpaceURI;
	}
	
	public boolean isPrefixed() {
		return nameSpaceURI!=null;
	}

	/**
	 * Returns the nameSpaceURI.
	 * @return String
	 */
	public String getNameSpaceURI() {
		return nameSpaceURI;
	}

	/**
	 * Sets the nameSpaceURI.
	 * @param nameSpaceURI The nameSpaceURI to set
	 */
	public void setNameSpaceURI(String nameSpaceURI) {
		this.nameSpaceURI = nameSpaceURI;
	}
	
	protected String getNsPrefix() {
		if (isPrefixed()) return nameSpaceURI+":";
		else return "";
	}
	

}

class ElementXmlTreeNode extends BaseXmlTreeNodeWithNamespace {
	
	private String tag;
	
	public ElementXmlTreeNode(BaseXmlTreeNode parent, String nameSpaceURI, String tag) {
		super(parent, nameSpaceURI);
		this.tag=tag;
	}
	
	/**
	 * Returns the tag.
	 * @return String
	 */
	public String getTag() {
		return tag;
	}

	/**
	 * Sets the tag.
	 * @param tag The tag to set
	 */
	public void setTag(String tag) {
		this.tag = tag;
	}
	
	protected String getLabel() { return "<"+getNsPrefix()+tag+">"; }

}

class AttributeXmlTreeNode extends BaseXmlTreeNodeWithNamespace {
	
	private String name;
	private String value;
	
	public AttributeXmlTreeNode(BaseXmlTreeNode parent, String name, String value) {
		super(parent, null);
		this.name=name;
		this.value=value;
	}
	
	/**
	 * Returns the name.
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * Returns the value.
	 * @return String
	 */
	public String getValue() {
		return value;
	}

	/**
	 * Sets the name.
	 * @param name The name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Sets the value.
	 * @param value The value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	protected String getLabel() { return "@"+name+"="+value; }
}

class TextXmlTreeNode extends BaseXmlTreeNode  {
	
	private String text;
	
	public TextXmlTreeNode(BaseXmlTreeNode parent, String text) {
		super(parent);
		this.text=text;
	}
	/**
	 * Returns the text.
	 * @return String
	 */
	public String getText() {
		return text;
	}

	/**
	 * Sets the text.
	 * @param text The text to set
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	protected String getLabel() { return "TEXT:"+text; }
}

class XmlTreeContentHandler extends DefaultHandler {
	
	private StringBuffer sb = new StringBuffer();
	private JTree tree;
	private BaseXmlTreeNode currentNode;
	private TreePath currentPath;

	
	public XmlTreeContentHandler(JTree tree) {
		this.tree=tree;
		// Expect the root node to be DocumentRootXmlTreeNode
		if (! (tree.getModel()  instanceof DefaultTreeModel)) 
			throw new RuntimeException("The given JTree has not a DefaultTreeModel");
		DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
		if (model.getRoot() == null)
			model.setRoot(new DocumentRootXmlTreeNode());
		else 
			if (!(model.getRoot() instanceof DocumentRootXmlTreeNode))
				throw new RuntimeException("The given JTree has not a DocumentRootXmlTreeNode object as a root node");
		this.currentNode=(DocumentRootXmlTreeNode)model.getRoot();
		this.currentPath=new TreePath(currentNode);
	}
	
	/**
	 * @see org.xml.sax.ContentHandler#characters(char[], int, int)
	 */
	public void characters(char[] chars, int start, int len)
		throws SAXException {
			for(int i=start;i<start+len;i++) {
				sb.append(chars[i]);
			}
	}

	/**
	 * @see org.xml.sax.ContentHandler#endDocument()
	 */
	public void endDocument() throws SAXException {
		currentNode=null;
	}

	/**
	 * @see org.xml.sax.ContentHandler#endElement(String, String, String)
	 */
	public void endElement(String nameSpaceURI, String localName, String qName)
		throws SAXException {
			TextXmlTreeNode txtNode = new TextXmlTreeNode(currentNode, sb.toString());
			currentNode.appendChild(txtNode);
			sb.delete(0, sb.length());
			//System.out.println("Expanding "+currentPath.pathByAddingChild(txtNode));
			//tree.expandPath(currentPath.pathByAddingChild(txtNode));
			currentNode=currentNode.getXmlParent();
			currentPath=currentPath.getParentPath();
	}

	/**
	 * @see org.xml.sax.ContentHandler#ignorableWhitespace(char[], int, int)
	 */
	public void ignorableWhitespace(char[] arg0, int arg1, int arg2)
		throws SAXException {
	}

	/**
	 * @see org.xml.sax.ContentHandler#processingInstruction(String, String)
	 */
	public void processingInstruction(String arg0, String arg1)
		throws SAXException {
	}

	/**
	 * @see org.xml.sax.ContentHandler#startDocument()
	 */
	public void startDocument() throws SAXException {
		
	}

	/**
	 * @see org.xml.sax.ContentHandler#startElement(String, String, String, Attributes)
	 */
	public void startElement(
		String nameSpaceURI,
		String localName,
		String qName,
		Attributes atts)
		throws SAXException {
			
			String []tmp=split(qName);
			ElementXmlTreeNode elemNode = new ElementXmlTreeNode(
				currentNode,
				tmp[0],
				tmp[1]);
			currentNode.appendChild(elemNode);
			currentPath=currentPath.pathByAddingChild(currentNode);
			tree.expandPath(currentPath);
			for(int i=0;i<atts.getLength();i++) {
				tmp=split(atts.getQName(i));
				
				AttributeXmlTreeNode attrNode = new AttributeXmlTreeNode(
					elemNode,
					tmp[1],
					atts.getValue(i)
				);
				elemNode.appendChild(attrNode);
			}
		currentNode=elemNode;
	}
	
	private String [] split(String qName) throws SAXException {
		int z;
		String ns=null, name;
		if ((z=qName.indexOf(":"))!=-1) {
			ns=qName.substring(0, z);
			if (qName.length()>=z)
				name=qName.substring(z+1);
			else throw new SAXException("Name can't be empty");
		} else name=qName;
		return new String[] { ns, name };
	}

	/**
	 * @see org.xml.sax.ContentHandler#startPrefixMapping(String, String)
	 */
	public void startPrefixMapping(String arg0, String arg1)
		throws SAXException {
	}

}

abstract class XmlTreeIcon extends ImageIcon {
	protected XmlTreeIcon(String imgName) throws IOException {
		super(getImageBytes(imgName));
	}
	
	private static byte [] getImageBytes(String imgName) throws IOException {
		
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(imgName);
		int c;
		while((c=is.read())!=-1) 
			os.write(c);
		is.close();
		os.close();
		return os.toByteArray();
	}
}

class ElementXmlIcon extends XmlTreeIcon {
	public ElementXmlIcon() throws IOException { super("element.jpg"); }
}

class AttributeXmlIcon extends XmlTreeIcon {
	public AttributeXmlIcon() throws IOException { super("attribute.gif"); }
}

class TextXmlIcon extends XmlTreeIcon {
	public TextXmlIcon() throws IOException { super("text.gif"); }
}