package classUtils.pack.util.ant;

import classUtils.pack.util.CPoolReader;
import classUtils.pack.util.CPoolReader;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 1, 2005
 * <p/>
 * Time: 12:00:52 PM
 */
public class PackagePrefixClassFilter
        implements ClassFilter {

    private String[] prefixes;
    private boolean accept;

    /**
     * Creates a filter which will accept or refuse (depending on the
     * <tt>accept</tt> parameter) classes whose package matches a given
     * prefix
     *
     * @param prefixes
     * @param accept
     */
    public PackagePrefixClassFilter(String[] prefixes,
                                    boolean accept) {
        this.prefixes = prefixes;
        this.accept = accept;
    }

    /**
     * Accepts the classes with or without one of the prefixes given at
     * construction
     */
    public boolean accept(String pkgName,
                          String clsName,
                          CPoolReader.ClassFile classFile) {
        for (int i = 0; i < prefixes.length; i++) {

            if (pkgName.startsWith(prefixes[i]))
                return accept;
        }
        return !accept;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Filter ");
        sb.append(accept ?
                "includes" :
                "excludes");
        sb.append(" classes in packages whose name is prefixed with one of { ");
        for (int i = 0; i < prefixes.length; i++) {
            sb.append(prefixes[i]);
            if (i < prefixes.length - 1)
                sb.append(", ");
        }
        sb.append(" }");
        return sb.toString();
    }
}
