package classUtils.pack.util.ant;

import classUtils.pack.util.ClassPackageExplorer;
import classUtils.pack.util.SimpleClassPackageExplorer;
import classUtils.putils.ClassPathUtils;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 2, 2005
 * <p/>
 * Time: 9:21:46 AM
 */
class PackTask extends Task {
    static final String DEFAULT_EXCLUDE_PACKAGES =
            "javax.swing,java.,sun.";
    private Pack pack;

    public PackTask(Pack pack) {
        this.pack = pack;
    }

    public void execute(){
        try {
            packIt();
        } catch (Exception e) {
            throw new BuildException(e);
        }
    }

    /**
     * Execute the task.
     *
     * @see org.apache.tools.ant.Task#execute()
     */
    public void packIt() throws IOException, ClassNotFoundException {
        pack.setIgnorableClasses();

        if (pack.hasCacheClassFiles())
            pack.setCache(true);

        pack.validateInput();
        String[] clsNames;
        if (pack.getClasses() != null) {
            // "classes" is specified (it has precedence)
            clsNames = ClassPathUtils.getStringArray(pack.getClasses());
        } else {
            String[] pkgNames = ClassPathUtils.getStringArray(pack.getPackages());
            String cp2 = pack.getClassPath();


            ClassPackageExplorer pkgExplorer = new SimpleClassPackageExplorer(
                    cp2);
            Set cls = new HashSet();
            for (int i = 0; i < pkgNames.length; i++) {

                log("Looking for classes in package " +
                        pkgNames[i] +
                        " using " +
                        cp2);
                String[] tmp = pkgExplorer.listPackage(pkgNames[i]);
                for (int j = 0; j < tmp.length; j++)
                    cls.add(tmp[j]);
            }

            clsNames = new String[cls.size()];
            cls.toArray(clsNames);
            log("Classes to pack computed from given packages list");
        }
        pack.setRefusedNames(new HashSet());
        if (pack.getIncludePkg() == null) {
            if (pack.getExcludePkg() == null)
                pack.setExcludePkg(DEFAULT_EXCLUDE_PACKAGES);
            pack.setFilter(new PackagePrefixClassFilter(
                            ClassPathUtils.getStringArray(pack.getExcludePkg()),
                            false));
        } else {
            pack.setFilter(new PackagePrefixClassFilter(
                            ClassPathUtils.getStringArray(pack.getIncludePkg()),
                            true));
        }

        if (pack.getExcludePkg() != null)
            log("Excluding packages prefixed with " +
                    pack.getExcludePkg());
        if (pack.getIncludePkg() != null)
            log("Including only packages prefixed with " +
                    pack.getIncludePkg());

        pack.computeDependencies(clsNames);


        // Add any additional class
        pack.addAdditionalClasses();

        // Write the resulting target jar
        pack.writeOutJar();
    }

    public void log(String o, int i) {
        log(o);
    }

    public void log(String o) {
       // System.out.println(o);
    }
}
