package classUtils.pack.util.ant;

import classUtils.pack.util.CPoolReader;
import classUtils.pack.util.DynamicJDK12ClassFileFinder;
import classUtils.pack.util.DynamicResourceFileFinder;
import classUtils.putils.ClassPathBean;

import java.io.IOException;
import java.io.InputStream;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 2, 2005
 * <p/>
 * Time: 3:08:28 AM
 */
public class ClassFinderUtils {
    private String classPath;

    ClassFinderUtils(String classPath) {
        this.classPath = classPath;
        init();
    }

    //todo understand how the DCFF works.
    private DynamicJDK12ClassFileFinder dynamicClassFileFinder;
    private DynamicResourceFileFinder dynamicResourceFileFinder;
    private CPoolReader classPoolReader;

    public String getClassPath() {
        return classPath;
    }

    public byte[] getClassBytes(String className) throws IOException,
                                                         ClassNotFoundException {

            return dynamicClassFileFinder.getClassBytes(className);
    }

    public void addClassPathEntry(String classpath) {
        dynamicClassFileFinder.addClassPathEntry(classpath);
        classPath = dynamicClassFileFinder.getClassPath();
        init();
    }

    private void init() {
        dynamicClassFileFinder
                = new DynamicJDK12ClassFileFinder(ClassPathBean.restore());
        dynamicResourceFileFinder = (DynamicJDK12ClassFileFinder)
                dynamicClassFileFinder;
        classPoolReader =
                new CPoolReader(dynamicClassFileFinder);
    }

    public void setCache(boolean b) {
        final DynamicJDK12ClassFileFinder dynamicJDK12ClassFileFinder
                = (DynamicJDK12ClassFileFinder) dynamicClassFileFinder;
        dynamicJDK12ClassFileFinder.setClassCacheOn(true);
    }

    public CPoolReader.ClassFile readClassData(byte[] byteCode)
            throws IOException {
        return
                classPoolReader.readClassData(byteCode);
    }

    public InputStream openResource(String name) throws IOException {
        return
                dynamicResourceFileFinder.openResource(name);
    }
}
