package classUtils.pack.util;

import classUtils.putils.ClassPathUtils;
import classUtils.putils.ClassPathBean;
import futils.Futil;
import gui.In;

/**
 * A {@link JDK12ClassFileFinder JDK12ClassFileFinder}
 *  whose classpath
 * definition can be changed at runtime.
 *
 * @author cris
 * @version 1.0.1
 */
//
public class DynamicJDK12ClassFileFinder
        extends JDK12ClassFileFinder
        implements DynamicClassFileFinder, DynamicResourceFileFinder {

    /**
     * Constructor for DynamicJDK12ClassFileFinder.
     *
     * @param classPathBean classPathBean
     */
    public DynamicJDK12ClassFileFinder(ClassPathBean classPathBean) {
        super(classPathBean);
    }

    public static void main(String[] args) {
        DynamicJDK12ClassFileFinder dcff =
                new DynamicJDK12ClassFileFinder(ClassPathBean.restore());
        System.out.println("using classpath:" + dcff.getClassPath());
        String cn = In.getString("enter class Name");
        boolean again = false;
        do {
            System.out.println("using classpath:" + dcff.getClassPath());
            try {
                dcff.getBytes(cn);
                In.message("got bytes for class:"+cn);

            } catch (Exception e) {
                e.printStackTrace();

            }
            again = In.getBoolean("try again?");
            if (again) {
                ClassPathUtils.addClassPath(
                        Futil.getReadFileDir(
                                "add class path").getAbsolutePath());
                dcff =
                        new DynamicJDK12ClassFileFinder(ClassPathBean.restore());
            }
        }
        while (again);
    }

    public void addClassPathEntry(String entry) {
        classPathBean.addClassPath(entry);
        this.classPathDirs = null; // Invalidate
    }

    public void setClassPath(String classPath) {
        classPathBean.setClassPath(classPath);
        this.classPathDirs = null; // Invalidate
    }

    /**
     * @see classUtils.pack.util.DynamicClassFileFinder#getClassPath()
     */
    public String getClassPath() {
        return classPathBean.getClassPath();
    }

}
