package classUtils.javassist.sample;

import classUtils.javassist.*;

import java.util.Collection;
import java.util.Iterator;

/*
   A very simple sample program

   This program overwrites sample/Test.class (the class file of this
   class itself) for adding a method g().  If the method g() is not
   defined in class Test, then this program adds a copy of
   f() to the class Test with name g().  Otherwise, this program does
   not modify sample/Test.class at all.

   To see the modified class definition, execute:

   % javap sample.Test

   after running this program.
*/

public class Test {
    public int f(int i) {

        return i + 1;
    }


    public static void main(String[] args) throws Exception {
        ClassPool cp
               = ClassPool.getDefault(null);

        CompileTimeClass cc = cp.get("javassist.sample.Test");
        System.out.println("getbytecodes:");
        byte b[] = cc.toBytecode();
        System.out.println("bytes in code="+b.length);
        System.out.println("refs=");
        printClassRefs(cc);

        try {
            cc.getDeclaredMethod("g");
            System.out.println("g() is already defined in sample.Test.");
        } catch (NotFoundException e) {
            /* getDeclaredMethod() throws an exception if g()
             * is not defined in sample.Test.
             */
            CtMethod fMethod = cc.getDeclaredMethod("f");
            //CtMethod gMethod = CtNewMethod.copy(fMethod, "g", cc, null);
            //cc.addMethod(gMethod);
            //cp.writeFile("sample.Test");	// update the class file
            //System.out.println("g() was added.");
        }
    }

    private static void printClassRefs(CompileTimeClass cc) {
        Collection c = cc.getRefClasses();
        try {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                System.out.println
                        ((String) i.next());
            }
        } catch (Exception e) {
            e.printStackTrace();

        }
    }
}
