package bookExamples.ch27BusinessGraphics.charts;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

public class GraphFrame extends Frame {

    private Plot1 Data;
    private String[] xaxis;
    private String[] yaxis;
    private Rectangle r;


    public static void main(String args[]) {
        double limit = 2 * Math.PI;
        double incr = 10;
        String xaxis[] = {"X", "1pi", "2pi", "3pi"};
        String yaxis[] = {"Sin(x)", "-1.0", "0.0", "1.0"};

        int n = (int) (1 + limit / incr);
        Plot1 data = new Plot1(n, xaxis, yaxis);

        for (double x = 0; x < limit; x += incr)
            data.push(x, Math.sin(2 * x), 0);

        GraphFrame pf = new GraphFrame("Eye Intensity", data);
        pf.setSize(400, 400);
        pf.setVisible(true);

    }


    public GraphFrame(String mark, Plot1 data1) {

        super(mark);
        Data = data1;
        xaxis = data1.getxA();
        yaxis = data1.getyA();
    }


    public void update(Graphics g) {
        g.clearRect(0, 0, r.width, r.height);
        paint(g);
    }


    public void paint(Graphics g) {
        r = getBounds();


        int w = r.width;
        int h = r.height;
        int leftMargin = 30;
        int tickMarkInterval = 10;
        int tickMarkWidth = 30;
        int middleY = h / 2 - 25;

        setBackground(Color.white);

        g.drawLine(leftMargin, middleY, w, middleY);
        g.drawLine(leftMargin, 0, leftMargin, h);

        for (int i = 1; i < w; i += tickMarkInterval)
            g.drawLine(i, middleY, i, h / 2 - tickMarkWidth);

        for (int j = 1; j < h; j += tickMarkInterval)
            g.drawLine(leftMargin, j, 35, j);

        g.drawString(yaxis[0], 35, h / 20);
        g.drawString(yaxis[1], 3, h / 4 * 3 - 5);
        g.drawString(yaxis[2], 5, middleY);
        g.drawString(yaxis[3], 5, h / 5 - 30);
        g.drawString(xaxis[0], w / 2, h / 4 * 3 + 20);
        g.drawString(xaxis[1], w / 3 - 5, h / 2 - 15);
        g.drawString(xaxis[2], w / 2 + 20, h / 2 - 15);
        g.drawString(xaxis[3], w - 80, h / 2 - 15);


        Point p1,p2;

        p1 = new Point(leftMargin, h / 3 + 37);
        double max = 2 * Math.PI;

        for (int t = 0; t < Data.getNum(); t++) {

            int x1 = (int) (Data.getx(t) * w / max + leftMargin);
            int y1 = (int) (h / 3 - (h / 3) * Data.gety(t) + 37);

            p2 = new Point(x1, y1);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            p1 = p2;
        }
    }

    public void actionPerformed(ActionEvent e) {

        if (e.getID() == WindowEvent.WINDOW_CLOSING)
            dispose();
    }

    public Plot1 getData() {
        return Data;
    }

    public void setData(Plot1 data) {
        Data = data;
    }

    public String[] getXaxis() {
        return xaxis;
    }

    public void setXaxis(String[] xaxis) {
        this.xaxis = xaxis;
    }

    public String[] getYaxis() {
        return yaxis;
    }

    public void setYaxis(String[] yaxis) {
        this.yaxis = yaxis;
    }

    public Rectangle getR() {
        return r;
    }

    public void setR(Rectangle r) {
        this.r = r;
    }
}

class Plot1 {
    private int num;
    private String x[];
    private String y[];

    private double x_d[];
    private double y_d[];
    private double z_d[];
    private int lct = 0;

    public Plot1(int nn, String[] xx, String[] yy) {
        num = nn;
        x = xx;
        y = yy;
        x_d = new double[num];
        y_d = new double[num];
        z_d = new double[num];
    }

    public String[] getxA() {
        return x;
    }

    public String[] getyA() {
        return y;
    }

    public int getsize() {
        return num;
    }

    public double getx(int dd) {
        return x_d[dd];
    }

    public double gety(int dd) {
        return y_d[dd];
    }

    public double getz(int dd) {
        return z_d[dd];
    }

    public void push(double xxx, double yyy, double zzz) {
        x_d[lct] = xxx;
        y_d[lct] = yyy;
        z_d[lct] = zzz;
        lct++;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String[] getX() {
        return x;
    }

    public void setX(String[] x) {
        this.x = x;
    }

    public String[] getY() {
        return y;
    }

    public void setY(String[] y) {
        this.y = y;
    }

    public double[] getX_d() {
        return x_d;
    }

    public void setX_d(double[] x_d) {
        this.x_d = x_d;
    }

    public double[] getY_d() {
        return y_d;
    }

    public void setY_d(double[] y_d) {
        this.y_d = y_d;
    }

    public double[] getZ_d() {
        return z_d;
    }

    public void setZ_d(double[] z_d) {
        this.z_d = z_d;
    }

    public int getLct() {
        return lct;
    }

    public void setLct(int lct) {
        this.lct = lct;
    }
}



