package bookExamples.ch26Graphics.draw2d;

import gui.run.RunMenuItem;
import gui.run.RunButton;
import gui.In;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.Point2D;
import java.beans.PropertyEditor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class Pentagon extends DJShape
        implements PropertyEditor {
    Color color = Color.BLACK;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public Pentagon(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        setX1(_x1);
        setY1(_y1);
    }

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        Pentagon pentagon = new Pentagon(x1, y1, x2, y2);
        pentagon.setAffineTransform(getAffineTransform());
        //pentagon.setColor(getColor());
        return pentagon;
    }

    public int getX() {
        return x1;
    }

    public int getY() {
        return y1;
    }

    public Point getCenter() {
        return new Point(x1, y1);
    }

    /*
     * Set (or change) the object that is to be edited.  Primitive types such
     * as "int" must be wrapped as the corresponding object type such as
     * "java.lang.Integer".
     *
     * @param value The new target object to be edited.  Note that this
     *     object should not be modified by the PropertyEditor, rather
     *     the PropertyEditor should create a new object to hold any
     *     modified value.
     */
/*
    public void setValue(Object value){
        if (value instanceof Pentagon){
            Pentagon newPentagon = (Pentagon)value;
            if (this.equals(newPentagon)) return;
            pcs.firePropertyChange("Pentagon", this, newPentagon);
//            this = newPentagon;
        }
    }
*/

    public void setValue(Object value){
        if (value instanceof Color){
            Color newColor = (Color)value;
            if (color.equals(newColor)) return;
            pcs.firePropertyChange("Pentagon", this, newColor);
            color = newColor;
        }
    }

    /*
     * Gets the property value.
     *
     * @return The value of the property.  Primitive types such as "int" will
     * be wrapped as the corresponding object type such as "java.lang.Integer".
     */

    public Object getValue(){
        return color;
    }

    //----------------------------------------------------------------------

    /*
     * Determines whether this property editor is paintable.
     *
     * @return  True if the class will honor the paintValue method.
     */

    public boolean isPaintable(){
        return false;
    }

    /*
     * Paint a representation of the value into a given area of screen
     * real estate.  Note that the propertyEditor is responsible for doing
     * its own clipping so that it fits into the given rectangle.
     * <p>
     * If the PropertyEditor doesn't honor paint requests (see isPaintable)
     * this method should be a silent noop.
     * <p>
     * The given Graphics object will have the default font, color, etc of
     * the parent container.  The PropertyEditor may change graphics attributes
     * such as font and color and doesn't need to restore the old values.
     *
     * @param gfx  Graphics object to paint into.
     * @param box  Rectangle within graphics object into which we should paint.
     */
    public void paintValue(java.awt.Graphics gfx, java.awt.Rectangle box){

//        repaint();
    }

    //----------------------------------------------------------------------

    /*
     * This method is intended for use when generating Java code to set
     * the value of the property.  It should return a fragment of Java code
     * that can be used to initialize a variable with the current property
     * value.
     * <p>
     * Example results are "2", "new Color(127,127,34)", "Color.orange", etc.
     *
     * @return A fragment of Java code representing an initializer for the
     *   	current value.
     */
    public String getJavaInitializationString(){
        return null;
    }

    //----------------------------------------------------------------------

    /*
     * Gets the property value as text.
     *
     * @return The property value as a human editable string.
     * <p>   Returns null if the value can't be expressed as an editable string.
     * <p>   If a non-null value is returned, then the PropertyEditor should
     *	     be prepared to parse that string back in setAsText().
     */
    public String getAsText(){
        return null;
    }

    /*
     * Set the property value by parsing a given String.  May raise
     * java.lang.IllegalArgumentException if either the String is
     * badly formatted or if this kind of property can't be expressed
     * as text.
     * @param text  The string to be parsed.
     */
    public void setAsText(String text) throws java.lang.IllegalArgumentException{
        try {
            color = Color.decode(text);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    //----------------------------------------------------------------------

    /*
     * If the property value must be one of a set of known tagged values,
     * then this method should return an array of the tags.  This can
     * be used to represent (for example) enum values.  If a PropertyEditor
     * supports tags, then it should support the use of setAsText with
     * a tag value as a way of setting the value and the use of getAsText
     * to identify the current value.
     *
     * @return The tag values for this property.  May be null if this
     *   property cannot be represented as a tagged value.
     *
     */
    public String[] getTags(){
        return new String[0];
    }

    //----------------------------------------------------------------------

    /*
     * A PropertyEditor may choose to make available a full custom Component
     * that edits its property value.  It is the responsibility of the
     * PropertyEditor to hook itself up to its editor Component itself and
     * to report property value changes by firing a PropertyChange event.
     * <P>
     * The higher-level code that calls getCustomEditor may either embed
     * the Component in some larger property sheet, or it may put it in
     * its own individual dialog, or ...
     *
     * @return A java.awt.Component that will allow a human to directly
     *      edit the current property value.  May be null if this is
     *	    not supported.
     */

    public java.awt.Component getCustomEditor(){
        JPanel jp = new JPanel();
        jp.add(new RunButton("Color") {
            public void run() {
                Pentagon.this.setValue(In.getColor());
                pcs.firePropertyChange("Pentagon",null,this);
            }
        });

        return jp;
    }

    /*
     * Determines whether this property editor supports a custom editor.
     *
     * @return  True if the propertyEditor can provide a custom editor.
     */
    public boolean supportsCustomEditor(){
        return true;
    }

    //----------------------------------------------------------------------

    /*
     * Register a listener for the PropertyChange event.  When a
     * PropertyEditor changes its value it should fire a PropertyChange
     * event on all registered PropertyChangeListeners, specifying the
     * null value for the property name and itself as the source.
     *
     * @param listener  An object to be invoked when a PropertyChange
     *		event is fired.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener){
        pcs.addPropertyChangeListener(listener);
    }

    /*
     * Remove a listener for the PropertyChange event.
     *
     * @param listener  The PropertyChange listener to be removed.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener){
        pcs.removePropertyChangeListener(listener);
    }

    public void draw(Graphics g) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double radius = Math.sqrt(dx * dx + dy * dy);
        //CircleFcn circle = new CircleFcn(x1, y1, radius);


       // Polygon p = new Polygon();

       // for (double t = 0; t < 1; t=t+0.2) {
       //     Point2D point = circle.getPoint(t);
      //      p.addPoint((int)point.getX(),(int)point.getY());

      //  }

        //Demonstrates that getCenter displays the center of the Pentagon.
        //System.out.println("Center of Pentagon: x = " + (int) getCenter().getX()
        //        + ", y = " + (int) getCenter().getY());

        //saveState(g);
        Graphics2D g2d = (Graphics2D) g;
        //g2d.drawPolygon(p);
        g2d.drawString("(" + x1 + "," + y1 + ")", x1 + 3, y1 + 3);
        //restoreState(g2d);
    }
}
