package bookExamples.ch26Graphics.draw2d;

/**
 * Created by IntelliJ IDEA.
 * User: default
 * Date: Feb 10, 2005
 * Time: 7:00:34 AM
 * To change this template use File | Settings | File Templates.
 */

import gui.In;
import gui.run.RunButton;
import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;


public class Octagon extends DJShape implements PropertyEditorFcn1 {
    int h = 1;
    int w = 1;
    int yc = 0;
    int xc = 0;

    double r = w / (2 * Math.sin(Math.toRadians(92)));
    double f = Math.sin(Math.toRadians(37)) /
            Math.sin(Math.toRadians(80));
    double q = w * f;


    public Octagon(int _x1, int _y1, int _x2, int _y2) {


        super(_x1, _y1, _x2, _y2);
        setX1(_x1);
        setY1(_y1);
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) setX1(_x2);
        if (_y1 > _y2) setY1(_y2);
        xc = x1 + w / 2;
        yc = y1 + (int) q - w / 2;
        setCenter();

    }


    private void setCenter() {
        xc = x1 + w / 2;
        yc = y1 + (int) q - w / 2;
    }

    public Point getCenter() {
        return new Point((int) xc, (int) yc);
    }

    public DJShape getInstance(int x1, int y1, int x2, int y2) {

        Octagon oct = new Octagon(x1, y1, x2, y2);

        return oct;

        //return new Octagon (x1,y1,x2,y2);
        //To change body of implemented methods use File | Settings | File Templates.
    }


    public void draw(Graphics g) {
        //saveState(g);
        xc = x1 + w / 2;
        yc = y1 + (int) q - w / 2;

        // AffineTransform at = new AffineTransform();
        // at.setToRotation(90 * Math.PI / 180, xc, yc);


        double n = Math.sin(Math.toRadians(37)) /
                Math.sin(Math.toRadians(80));
        double a = w * n;


        int[] xPoints = {(int) (x1 + w / 2 - a / 2), (int) (x1 + w / 2 + a / 2),
                         x1 + w, x1 + w, (int) (x1 + w / 2 + a / 2),
                         (int) (x1 + w / 2 - a / 2), x1, x1};


        int yPoints[] = {y1, y1, (int) (y1 - a / 2), (int) (y1 - w + a / 2),
                         y1 - w, y1 - w, (int) (y1 - w + a / 2), (int) (y1 - a / 2)};

        //  Point pc = getCenter();
        Graphics2D g2d = (Graphics2D) g;
        g2d.setColor(getForeground());
        g2d.setTransform(at);
        at.setTransform(at);


        g2d.drawPolygon(xPoints, yPoints, 8);
        g2d.fillOval(xc, yc, 2, 2);

        g2d.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);
        // restoreState(g);


    }

    public String toString() {

        return
                "Octagon";
    }


    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);

    }


    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }


    String value;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public boolean isPaintable() {
        return true;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public boolean supportsCustomEditor() {
        return true;
    }


    public Component getCustomEditor() {
        JPanel jp = new JPanel();
        //Container c = jd.getContentPane();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("y1"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, yc) {
            public void run() {
                y1 = getValue();
                pcs.firePropertyChange("size", Octagon.this, null);
            }
        });

        jp.add(new JLabel("x1"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, xc) {
            public void run() {
                x1 = getValue();
                pcs.firePropertyChange("size", Octagon.this, null);
            }
        });
        jp.add(new JLabel("w"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, w) {
            public void run() {
                w = getValue();
                pcs.firePropertyChange("size", Octagon.this, null);
            }
        });
        jp.add(new RunButton("setForeground") {
            public void run() {
                Octagon.this.setForeground(In.getColor());
                //  pcs.firePropertyChange("Octagon",null,this);
                pcs.firePropertyChange("size", Octagon.this, null);
            }
        });

        jp.setLayout(new FlowLayout());

        return jp;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object newValue) {
        value = (String) newValue;
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        //return new String[0];
        return null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        //To change body of implemented methods use File | Settings | File Templates.
        // gfx.setClip(box);
        // gfx.drawString("click to edit...", box.x+5,box.y+15);
    }


    public Point2D getPoint(double t) {
        return new Point2D.Float(xc, yc);  //To change body of implemented methods use File | Settings | File Templates.
    }
}








