package bookExamples.ch26Graphics.draw2d;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;

public class FillRect2d extends DJShape {
    int x1 = 0;
    int y1 = 0;
    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        FillRect2d fillRect2d = new FillRect2d(x1, y1, x2, y2);
        fillRect2d.setAffineTransform(at);
        
        return fillRect2d;
    }

    public int getX1() {
        return x1;
    }

    public int getY1() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }

    public Point getCenter(){
        return new Point(x1+w/2,y1+h/2);
    }
    public FillRect2d(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        x1 = _x1;
        y1 = _y1;
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) x1 = _x2;
        if (_y1 > _y2) y1 = _y2;
        xc = x1 + w / 2;
        yc = y1 + h / 2;
        at.setToIdentity();
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        //saveState(g);
        g2.setTransform(at);
        g2.fill3DRect(x1, y1, w, h, true);
        g2.fillOval(xc, yc, 2, 2);
        g2.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);
        //restoreState(g);
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}
