package bookExamples.ch26Graphics.draw2d;

import gui.In;
import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class Cylinder extends DJShape implements PropertyEditor {
    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;
    int cf = 0;


    public PropertyChangeSupport pcs = new PropertyChangeSupport(this);


    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        Cylinder cyl = new Cylinder(x1, y1, x2, y2);
        cyl.setForeground(getForeground());
        cyl.setAffineTransform(getAffineTransform());
        return cyl;

    }

    public int getX() {
        return x1;
    }

    public int getY() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }


    public Cylinder(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        setX1(_x1);
        setY1(_y1);
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) setX1(_x2);
        if (_y1 > _y2) setY1(_y2);
        xc = x1 + w / 2;
        yc = y1 + h / 2;
        cf = h / 8;
        y2 = y1 + h;

    }

    public Point getCenter() {
        return new Point(xc, yc);
    }

    int centroid [] = {w / 2, w / 2};

    Polygon p5 = new Polygon();

    //Mat3 at;

    Graphics tempg;

    int theta = 0;
    double shear_x = 0.0;
    double shear_y = 0.0;
    double tx = 0.0;
    double ty = 0.0;
    AffineTransform at = new AffineTransform();

    public void draw(Graphics g) {

        Point2D p = getCenter();

        int x = (int) p.getX();
        int y = (int) p.getY();

        // AffineTransform at = new AffineTransform();
        // AffineTransform st = new AffineTransform();

        //at.setToShear(shear_x, shear_y );
        //at.setToRotation(theta*Math.PI/180, x, y);
        Graphics2D g2d = (Graphics2D) g;
        g2d.setTransform(at);

        g2d.setColor(getForeground());
        g2d.drawLine(x1, y1, x1, y2);
        g2d.drawLine(x1 + w, y1, x1 + w, y2);

        g2d.drawOval(x1, y1 - cf, w, h / 4);
        g2d.drawOval(x1, y2 - cf, w, h / 4);

        g2d.fillOval(xc, yc, 2, 2);
        g2d.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);

    }


    //Method to support Custom Editing
    public Point2D getPoint(double t) {

        return new Point2D.Double();
    }

    //Test Method to view CODE analysis
    public boolean isPaintable() {
        System.out.println("In boolean Method");
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void update() {

        pcs.firePropertyChange("Cylinder", this, null);
    }


    public JButton colorButton;

    public java.awt.Component getCustomEditor() {

        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("Location X"));
        jp.add(new RunSlider(RunSlider.VERTICAL,
                -500,
                500,
                Cylinder.this.x1) {
            public void run() {


                pcs.firePropertyChange("", this, null);

                Cylinder.this.x1 = getValue();
                Cylinder.this.x2 = x1 + getValue();
                Cylinder.this.xc = (Cylinder.this.x1 + w / 2);

                Cylinder.this.update();
            }
        });
        jp.add(new JLabel("Location Y"));
        jp.add(new RunSlider(RunSlider.VERTICAL,
                -500,
                500,
                Cylinder.this.y1) {
            public void run() {

                pcs.firePropertyChange("", this, null);

                Cylinder.this.y1 = getValue();
                Cylinder.this.y2 = y1 + h;

                Cylinder.this.yc = (Cylinder.this.y1 + h / 2);

                Cylinder.this.update();
            }
        });


        jp.add(new JLabel("Width"));
        jp.add(new RunSlider(RunSlider.VERTICAL,
                10,
                500,
                Cylinder.this.w) {
            public void run() {
                int value = getValue();
                System.out.println(value);
                pcs.firePropertyChange("", this, null);
                Cylinder.this.w = value;
                Cylinder.this.xc = (Cylinder.this.x1 +
                        Cylinder.this.x1 +
                        w) /
                        2;
                Cylinder.this.update();
            }
        });

        jp.add(new JLabel("Height"));
        jp.add(new RunSlider(RunSlider.VERTICAL, -500, 500, 0) {
            public void run() {
                int value = getValue();

                System.out.println(value);
                pcs.firePropertyChange("", this, null);
                //Cylinder.this.y1 = value;
                Cylinder.this.y2 = Cylinder.this.y1 + h + value;
                Cylinder.this.yc = (Cylinder.this.y1 + Cylinder.this.y2) /
                        2;
                Cylinder.this.update();
            }
        });

        jp.add(new JLabel("Angle"));
        jp.add(new RunSlider(RunSlider.VERTICAL, 0, 360, 0) {
            public void run() {
                int value = getValue();
                Point2D p = getCenter();
                int x = (int) p.getX();
                int y = (int) p.getY();

                pcs.firePropertyChange("", this, null);

                Cylinder.this.theta = value;
                at.setToRotation(theta * Math.PI / 180, xc, yc);

                Cylinder.this.update();
            }
        });

        jp.add(new JLabel("Shear X"));
        jp.add(new RunSlider(RunSlider.VERTICAL, -20, 20, 0) {
            public void run() {
                int value = getValue();
                Point2D p = getCenter();
                int x = (int) p.getX();
                int y = (int) p.getY();
                double temp = value * 0.1;
                pcs.firePropertyChange("", this, null);
                Cylinder.this.shear_x = temp;
                at.setToShear(shear_x, shear_y);
                Cylinder.this.update();
            }
        });

        jp.add(new JLabel("Shear Y"));
        jp.add(new RunSlider(RunSlider.VERTICAL, -20, 20, 0) {
            public void run() {
                int value = getValue();
                Point2D p = getCenter();
                int x = (int) p.getX();
                int y = (int) p.getY();
                double temp = value * 0.1;
                pcs.firePropertyChange("", this, null);
                Cylinder.this.shear_y = temp;
                at.setToShear(shear_x, shear_y);
                Cylinder.this.update();
            }
        });


        colorButton = new JButton("Color");
        colorButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                System.out.println("In Color");
                Cylinder.this.setForeground(In.getColor());
                Cylinder.this.update();
            }
        });
        jp.add(colorButton);

        jp.setVisible(true);
        return jp;
    }

    /**
     * Register a listener for the PropertyChange event.  When a
     * PropertyEditor changes its value it should fire a PropertyChange
     * event on all registered PropertyChangeListeners, specifying the null
     * value for the property name and itself as the source.
     *
     * @param listener An object to be invoked when a PropertyChange event
     *                 is fired.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * Remove a listener for the PropertyChange event.
     *
     * @param listener The PropertyChange listener to be removed.
     */
    public void removePropertyChangeListener(
            PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * Gets the property value.
     *
     * @return The value of the property.  Primitive types such as "int"
     *         will be wrapped as the corresponding object type such as
     *         "java.lang.Integer".
     */

    public Object getValue() {
        return null;
    }

    /**
     * Set (or change) the object that is to be edited.  Primitive types
     * such as "int" must be wrapped as the corresponding object type such
     * as "java.lang.Integer".
     *
     * @param value The new target object to be edited.  Note that this
     *              object should not be modified by the PropertyEditor,
     *              rather the PropertyEditor should create a new object to
     *              hold any modified value.
     */
    public void setValue(Object value) {
    }

    /**
     * Gets the property value as text.
     *
     * @return The property value as a human editable string. <p>   Returns
     *         null if the value can't be expressed as an editable string.
     *         <p>   If a non-null value is returned, then the
     *         PropertyEditor should be prepared to parse that string back
     *         in setAsText().
     */
    public String getAsText() {
        return null;
    }

    /**
     * This method is intended for use when generating Java code to set the
     * value of the property.  It should return a fragment of Java code
     * that can be used to initialize a variable with the current property
     * value.
     * <p/>
     * Example results are "2", "new Color(127,127,34)", "Color.orange",
     * etc.
     *
     * @return A fragment of Java code representing an initializer for the
     *         current value.
     */
    public String getJavaInitializationString() {
        return null;
    }

    /**
     * If the property value must be one of a set of known tagged values,
     * then this method should return an array of the tags.  This can be
     * used to represent (for example) enum values.  If a PropertyEditor
     * supports tags, then it should support the use of setAsText with a
     * tag value as a way of setting the value and the use of getAsText to
     * identify the current value.
     *
     * @return The tag values for this property.  May be null if this
     *         property cannot be represented as a tagged value.
     */
    public String[] getTags() {
        return new String[0];
    }

    /**
     * Set the property value by parsing a given String.  May raise
     * java.lang.IllegalArgumentException if either the String is badly
     * formatted or if this kind of property can't be expressed as text.
     *
     * @param text The string to be parsed.
     */
    public void setAsText(String text) throws IllegalArgumentException {
    }

    /**
     * Paint a representation of the value into a given area of screen real
     * estate.  Note that the propertyEditor is responsible for doing its
     * own clipping so that it fits into the given rectangle.
     * <p/>
     * If the PropertyEditor doesn't honor paint requests (see isPaintable)
     * this method should be a silent noop.
     * <p/>
     * The given Graphics object will have the default font, color, etc of
     * the parent container.  The PropertyEditor may change graphics
     * attributes such as font and color and doesn't need to restore the
     * old values.
     *
     * @param gfx Graphics object to paint into.
     * @param box Rectangle within graphics object into which we should
     *            paint.
     */
    public void paintValue(Graphics gfx, Rectangle box) {
    }


}
