package bookExamples.ch26Graphics.draw2d;

import gui.In;
import gui.run.RunButton;
import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 * Created by IntelliJ IDEA.
 * User: Gino Lopes
 * Date: Feb 12, 2005
 * Time: 5:16:33 PM
 * To change this template use File | Settings | File Templates.
 * /
 * <p/>
 * /*Creates a cone based on the starting mouse click as the center of cone.
 */

public class Cone2d extends DJShape
        implements PropertyEditorFcn1 {
    int x1 = 0;
    int y1 = 0;
    int diameter = 1;
    int radius = 1;
    double radiusSq;
    int startAngle = 180;
    int arcAngle = 180;
    int x, y;

    // start of code added for homework 5
    String value;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public String toString() {
        return "x1=" + x1 +
                "y1=" + y1 +
                "radius=" + radius +
                " shape=Cone2d";
    }

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Cone2d(x1, y1, x2, y2);
    }// end getInstance()

    public Cone2d(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        x1 = _x1;
        y1 = _y1;
        int dx = x1 - _x2;
        int dy = y1 - _y2;
        diameter = (int) Math.sqrt(dx * dx + dy * dy);
        if (_x1 > _x2) x1 = _x2;
        if (_y1 > _y2) y1 = _y2;
        radius = diameter / 2;
        radiusSq = radius * radius;
    }// end Cone2d()

    public void draw(Graphics g) {
        Point2D pc = getCenter();
        x = (int) pc.getX();
        y = (int) pc.getY();

        // calculates the three points to draw cone sides
        //CircleFcn cf = new CircleFcn(x, y, radius);
        double v = (0.25 + 1 / 3.0);
        Point2D p1 = getPoint(1 - 0.25);
        Point2D p2 = getPoint(1 - v);
        Point2D p3 = getPoint(1 - (v + 1 / 3.0));

        // creates cone arc
        Point2D p4 = getPoint(1 - 0.75);
        double w = Math.abs(p3.getX() - p2.getX());
        double h = Math.abs(p4.getY() - p2.getY());

        // start of code added for homework 4
        Graphics2D g2d = (Graphics2D) g;
        Color saveColor = g2d.getColor();
        g2d.setColor(getForeground());

        // end of code added for homework 4

        // draws the cone and lines for cone sides
        g2d.drawArc((int) p2.getX(), (int) p2.getY() - (int) h / 2, (int) w, (int) h, startAngle, arcAngle);
        drawLine(p1, p2, g);
        drawLine(p3, p1, g);

        // displays center point of cone
        g2d.fillOval(x, y, 2, 2);
        g2d.drawString("(" + x + "," + y + ")", x + 3, y + 3);

        // start of code added for homework 4
        g2d.setTransform(at);
        g2d.setColor(saveColor);
        restoreState(g2d);
        // end of code added for homework 4
    }// end paint()

    public Point getCenter() {
        return new Point(x1, y1);
    }// end getCenter()


    public Point2D getPoint(double t) {
        int xc = x;
        int yc = y;
        t = 2 * Math.PI * t;
        float x = (float) (radius * Math.cos(t) + xc);
        float y = (float) (radius * Math.sin(t) + yc);
        return new Point2D.Float(x, y);
    }

    public boolean isPaintable() {
        return true;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        //final String oldSizeValue = (String) ((Object) cone2d.getSize());
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("size"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 1, 2000, radius) {
            public void run() {
                pcs.firePropertyChange("coneHead", this, null);
                radius = getValue();
            }
        });
        jp.add(new JLabel("x1"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 1, 2000, radius) {
            public void run() {
                pcs.firePropertyChange("coneHead", this, null);
                x1 = getValue();
            }
        });
        jp.add(new JLabel("y1"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 1, 2000, radius) {
            public void run() {
                pcs.firePropertyChange("coneHead", this, null);
                y1 = getValue();
            }
        });
        jp.add(new RunButton("color") {
            public void run() {
                Color c = In.getColor();
                pcs.firePropertyChange("coneHead", this, null);
                Cone2d.this.setForeground(c);
            }
        });
        return jp;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object newValue) {
        value = (String) newValue;
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        //return new String[0];
        return null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        //To change body of implemented methods use File | Settings | File Templates.
        gfx.setClip(box);
        gfx.drawString("click to edit...", box.x + 5, box.y + 15);
    }
    // end of code added for homework 5

} // end class Cone2d
