package bookExamples.ch26Graphics.carl.phasor;

/*  Hi All!  As you can see, this text which you are reading is a comment in a java program, so you can take this whole e-mail message and paste it into a text file in a CodeWarrior project, and it will run if you name it "PhasorJFrame.java" and set the target of "Java Application Release Settings" to "PhasorJFrame".  RUN THIS PROGRAM!!!!  It illustrates the sum of two phasors in real-time. Omega1 and amp1 are associated with the green vector and omega2 and amp2 with the red vector.  The tips of the vectors are black dots for omega1 and bluish for omega2.  Change the values of omega1 and omega2 (to values such as 1 and -1, or 2 and 4,  or 10 and 20) and observe what happens.  Interpret these in terms of the text in pages 15 and 16 of Steiglitz.  If you un-comment one of the other two lines in the "paint" method, you will see 1)the individual steps of the vector addition or 2)the sine-wave beat, making sure that only one line is uncommented and the other two are commented out.

Anyone who wants extra credit can create JButtons and JTextfields to modify the values of omega's and amp's (amplitudes), and branch the lines in the paint method.

*/



import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
class PhasorJFrame extends JFrame{

	int x1, y1, x2, y2;
	double omega1 = 1;
	double omega2 = 1.1;

	double amp1 = 60;
	double amp2 = 80;

	double theta = 0;
	int xcen = 250;
	int ycen = 250;

	int xOffset = 0;

	double t = 0;
	double delt = .05;

	boolean firstStep;

	PhasorJFrame(){
		super(" This is phasor demo" );
		firstStep = true;

		Container c = getContentPane();

		x1 = 150;
		y1 = 150;

		x2 = 150;
		y2 = 150;

		xcen = 250;
		ycen = 250;

		TickListener tocker = new TickListener();
		setLocation(400,300);
		setSize(500,500);
		show();

		Timer ticker =  new Timer(100, tocker);
		ticker.start();
	}

	private class TickListener implements ActionListener {
		public void actionPerformed(ActionEvent e){
			//System.out.print (" Tick ");
			upDateGeometry();
			repaint();
		}
	}

	public void paint(Graphics g){
	//	super.paintComponents(g);
		drawPhasor(g);
	//	drawCosine(g);
	}

	public void drawPhasor(Graphics g1){
		if ( firstStep ) {
			firstStep = false;
			return;
		}
		g1.setColor(Color.green);
		int xtip = xcen + x1;
		int ytip = ycen + y1;
		g1.drawLine(xcen, ycen, xtip, ytip );
		g1.setColor(Color.red);
		g1.drawLine( xtip, ytip, xtip + x2, ytip + y2);
		g1.setColor(Color.black);
		g1.fillOval(xtip, ytip, 4, 4);
		g1.setColor(Color.cyan);
		g1.fillOval(xtip + x2, ytip + y2, 4, 4);
	}

	public void drawCosine(Graphics g2){

		if ( firstStep ) return;
		g2.setColor(Color.red);
		xOffset += 2;
		g2.drawOval( xOffset, ycen -( x1 + x2), 4, 4);

		if ( xOffset > 400) {
			g2.clearRect(0,0,500,500);
			xOffset = 0;
		}

	}

	public void upDateGeometry(){

		t += delt;

		double theta1 = Math.PI*t*omega1;
		double theta2 = Math.PI*t*omega2;

		x1 = (int)(amp1*Math.cos(-theta1));
		y1 = (int)(amp1*Math.sin(-theta1));

		x2 = (int)(amp2*Math.cos(-theta2));
		y2 = (int)(amp2*Math.sin(-theta2));

	}

	public static void main (String args[]){
		PhasorJFrame pjf = new PhasorJFrame();

		// Orderly window closing:
		pjf.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
      });
	}

}